package gov.va.cpss.service.impl.vfs;

import org.apache.log4j.Level;

public class JschLogger implements com.jcraft.jsch.Logger {

	private static final org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger(JschLogger.class.getCanonicalName());
	
	@Override
	public boolean isEnabled(int level) {
		return level >= JschLogger.getlog4jLevelAsJschLevel();
	}

	@Override
	public void log(int level, String message) {
		if (isEnabled(level)) {
			logger.log(JschLogger.convertJschLevelToLog4jLevel(level), message);
		}
	}
	
	private static int getlog4jLevelAsJschLevel() {
		final Level log4jLevel = logger.getEffectiveLevel();
		final int log4jLevelInt = (log4jLevel == null) ? Level.FATAL.toInt() : log4jLevel.toInt();
		
		int jschLevel = FATAL;
		
		if (log4jLevelInt <= Level.ERROR.toInt()) jschLevel = ERROR;
		if (log4jLevelInt <= Level.WARN.toInt()) jschLevel = WARN;
		if (log4jLevelInt <= Level.INFO.toInt()) jschLevel = INFO;
		if (log4jLevelInt <= Level.DEBUG.toInt()) jschLevel = DEBUG;
		
		return jschLevel;
	}
	
	private static Level convertJschLevelToLog4jLevel(int jschLevel) {
		switch (jschLevel) {
		case FATAL:
			return Level.FATAL;
		case ERROR:
			return Level.ERROR;
		case WARN:
			return Level.WARN;
		case INFO:
			return Level.INFO;
		case DEBUG:
			return Level.DEBUG;
		}
		return Level.FATAL;
	}

}
