package gov.va.cpss.service.impl.si;

//Remove stub class if using implementation
public class SpringIntegrationSftpServiceImpl {
}

//Commenting to remove Spring Integration dependency from project

//import java.io.File;
//import java.io.InputStream;
//import java.util.ArrayList;
//import java.util.Collections;
//import java.util.List;
//
//import org.apache.log4j.Logger;
//import org.springframework.integration.channel.DirectChannel;
//import org.springframework.integration.file.remote.FileInfo;
//import org.springframework.integration.file.remote.session.Session;
//import org.springframework.messaging.Message;
//import org.springframework.messaging.MessageHeaders;
//import org.springframework.messaging.PollableChannel;
//import org.springframework.messaging.support.GenericMessage;
//import org.springframework.messaging.support.MessageBuilder;
//import org.springframework.stereotype.Service;
//
//import gov.va.cpss.service.FileData;
//import gov.va.cpss.service.SftpService;
//import gov.va.cpss.service.SftpStreamSession;
//
///**
// * Service class for handling activities relating to sftp.
// * 
// * Converted to Interface/Implementation class to support migration to Apache
// * VFS - Brad Pickle 10/3/2016
// * 
// * @author DNS  
// */
//@Service
//public class SpringIntegrationSftpServiceImpl implements SftpService {
//
//	private static final Logger logger = Logger.getLogger(SpringIntegrationSftpServiceImpl.class.getCanonicalName());;
//
//	private static final String FTP_RENAME_TO_HEADER = "file_renameTo";
//
//	private static final String FTP_TARGET_FILE_TO_HEADER = "targetFile";
//
//	private static final String FTP_TARGET_DIR_TO_HEADER = "targetDir";
//
//	private static final String FTP_HEADER_FILE_REMOTE_SESSION = "file_remoteSession";
//
//	private Integer ftpTimeout; // ftp timeout
//
//	private DirectChannel inboundGetStream; // get request
//
//	private DirectChannel inboundChannelLs; // ls request
//
//	private DirectChannel inboundChannelSize; // ls size request
//
//	private DirectChannel inboundChannelLsFileInfo; // ls request
//
//	private DirectChannel outboundChannelPut; // put request
//
//	private DirectChannel outboundChannelMove; // move request
//
//	private DirectChannel outboundChannelRemove; // remove request
//
//	private PollableChannel stream; // reply as stream
//
//	private PollableChannel output; // reply as message
//
//	public SpringIntegrationSftpServiceImpl() {
//	}
//
//	public Integer getFtpTimeout() {
//		return ftpTimeout;
//	}
//
//	public void setFtpTimeout(Integer ftpTimeout) {
//		this.ftpTimeout = ftpTimeout;
//	}
//
//	public DirectChannel getInboundGetStream() {
//		return inboundGetStream;
//	}
//
//	public void setInboundGetStream(DirectChannel inboundGetStream) {
//		this.inboundGetStream = inboundGetStream;
//	}
//
//	public DirectChannel getInboundChannelLs() {
//		return inboundChannelLs;
//	}
//
//	public void setInboundChannelLs(DirectChannel inboundChannelLs) {
//		this.inboundChannelLs = inboundChannelLs;
//	}
//
//	public DirectChannel getInboundChannelSize() {
//		return inboundChannelSize;
//	}
//
//	public void setInboundChannelSize(DirectChannel inboundChannelSize) {
//		this.inboundChannelSize = inboundChannelSize;
//	}
//
//	public DirectChannel getInboundChannelLsFileInfo() {
//		return inboundChannelLsFileInfo;
//	}
//
//	public void setInboundChannelLsFileInfo(DirectChannel inboundChannelLsFileInfo) {
//		this.inboundChannelLsFileInfo = inboundChannelLsFileInfo;
//	}
//
//	public DirectChannel getOutboundChannelPut() {
//		return outboundChannelPut;
//	}
//
//	public void setOutboundChannelPut(DirectChannel outboundChannelPut) {
//		this.outboundChannelPut = outboundChannelPut;
//	}
//
//	public DirectChannel getOutboundChannelMove() {
//		return outboundChannelMove;
//	}
//
//	public void setOutboundChannelMove(DirectChannel outboundChannelMove) {
//		this.outboundChannelMove = outboundChannelMove;
//	}
//
//	public DirectChannel getOutboundChannelRemove() {
//		return outboundChannelRemove;
//	}
//
//	public void setOutboundChannelRemove(DirectChannel outboundChannelRemove) {
//		this.outboundChannelRemove = outboundChannelRemove;
//	}
//
//	public PollableChannel getStream() {
//		return stream;
//	}
//
//	public void setStream(PollableChannel stream) {
//		this.stream = stream;
//	}
//
//	public PollableChannel getOutput() {
//		return output;
//	}
//
//	public void setOutput(PollableChannel output) {
//		this.output = output;
//	}
//
//	/**
//	 * Transfer the specified file path to the default directory on the server.
//	 * If the filepath is to a file the file will be sent to the default
//	 * directory on the server. IF the filepath is a directory then all files
//	 * will be sent to the default directory on the server.
//	 * 
//	 * @param filepath
//	 *            The path of the file or directory to send to the server.
//	 * 
//	 * @return Boolean flag indicating success or failure.
//	 */
//	@Override
//	public boolean ftpFileToServer(final String filepath) {
//		return ftpFileToServer(filepath, ".");
//	}
//
//	/**
//	 * Transfer the specified file path to the specified directory on the
//	 * server. If the filepath is to a file the file will be sent to the default
//	 * directory on the server. IF the filepath is a directory then all files
//	 * will be sent to the default directory on the server.
//	 * 
//	 * @param filepath
//	 *            The path of the file or directory to send to the server.
//	 * @param targetDirectory
//	 *            The relative target directory on the server.
//	 * @return Boolean flag indicating success or failure.
//	 */
//	@Override
//	public boolean ftpFileToServer(final String filepath, final String targetDirectory) {
//
//		boolean successful = false;
//
//		try {
//
//			File file = new File(filepath);
//
//			if (outboundChannelPut
//					.send(MessageBuilder.withPayload(file).setHeader(FTP_TARGET_DIR_TO_HEADER, targetDirectory)
//							.setHeader(FTP_TARGET_FILE_TO_HEADER, file.getName()).build(), ftpTimeout)) {
//
//				Message<?> msgs = output.receive(ftpTimeout);
//
//				if (msgs != null) {
//
//					Object payload = msgs.getPayload();
//
//					if (payload instanceof String) {
//
//						final String mL = (String) payload;
//						if (mL.contains(file.getName())) {
//							successful = true;
//						}
//
//					} else if (payload instanceof List) {
//
//						@SuppressWarnings("unchecked")
//						final List<String> mL = (List<String>) payload;
//						if (file.isDirectory()) {
//							if (mL.size() == file.list().length) {
//								successful = true;
//							}
//						}
//					} else {
//						logger.error("Unexpected type of payload");
//					}
//				}
//			}
//
//		} catch (Exception e) {
//			logger.error("Unexpected exception during ftp put: " + e.getMessage());
//		}
//
//		return successful;
//	}
//
//	/**
//	 * Sent the specified local filepath to the server as the specified target
//	 * filename in the target directory on the server.
//	 * 
//	 * @param filepath
//	 *            The local filepath to send.
//	 * @param targetFilename
//	 *            The target filename on the server.
//	 * @param targetDirectory
//	 *            The target directory for the target filename on the server.
//	 * @return Boolean flag indicating if successful or not.
//	 */
//	@Override
//	public boolean ftpFileToServerWithName(final String filepath, final String targetFilename,
//			final String targetDirectory) {
//
//		boolean successful = false;
//
//		try {
//
//			File file = new File(filepath);
//
//			if (outboundChannelPut
//					.send(MessageBuilder.withPayload(file).setHeader(FTP_TARGET_DIR_TO_HEADER, targetDirectory)
//							.setHeader(FTP_TARGET_FILE_TO_HEADER, targetFilename).build(), ftpTimeout)) {
//
//				Message<?> msgs = output.receive(ftpTimeout);
//
//				if (msgs != null) {
//
//					Object payload = msgs.getPayload();
//
//					if (payload instanceof String) {
//
//						final String mL = (String) payload;
//						if (mL.contains(targetFilename)) {
//							successful = true;
//						}
//
//					} else if (payload instanceof List) {
//
//						@SuppressWarnings("unchecked")
//						final List<String> mL = (List<String>) payload;
//						if (file.isDirectory()) {
//							if (mL.size() == file.list().length) {
//								successful = true;
//							}
//						}
//					} else {
//						logger.error("Unexpected type of payload");
//					}
//				}
//			}
//
//		} catch (Exception e) {
//			logger.error("Unexpected exception during ftp put: " + e.getMessage());
//		}
//
//		return successful;
//	}
//
//	/**
//	 * Send an empty file to the sftp server in the specified target directory
//	 * with the specified name.
//	 * 
//	 * @param targetFilename
//	 *            The name of the resulting empty file on the sftp server.
//	 * @param targetDirectory
//	 *            The target directory on the sftp server.
//	 * @return Boolean flag indicating successful or not.
//	 */
//	@Override
//	public boolean ftpEmptyFileToServerWithName(final String targetFilename, final String targetDirectory) {
//		return ftpStringAsFileToServerWithName("", targetFilename, targetDirectory);
//	}
//
//	/**
//	 * Send the specified string content as the specified file content to the
//	 * sftp server int he specified target directory with the specified name.
//	 * 
//	 * @param content
//	 *            The content of the target file.
//	 * @param targetFilename
//	 *            The name of the resulting file on the sftp server.
//	 * @param targetDirectory
//	 *            The target directory on the sftp server.
//	 * @return Boolean flag indicating successful or not.
//	 */
//	@Override
//	public boolean ftpStringAsFileToServerWithName(final String content, final String targetFilename,
//			final String targetDirectory) {
//
//		boolean successful = false;
//
//		try {
//
//			if (outboundChannelPut
//					.send(MessageBuilder.withPayload(content).setHeader(FTP_TARGET_DIR_TO_HEADER, targetDirectory)
//							.setHeader(FTP_TARGET_FILE_TO_HEADER, targetFilename).build(), ftpTimeout)) {
//
//				Message<?> msgs = output.receive(ftpTimeout);
//
//				if (msgs != null) {
//
//					Object payload = msgs.getPayload();
//
//					if (payload instanceof String) {
//
//						final String mL = (String) payload;
//						if (mL.contains(targetFilename)) {
//							successful = true;
//						}
//
//					} else {
//						logger.error("Unexpected type of payload for empty file put");
//					}
//				}
//			}
//
//		} catch (Exception e) {
//			logger.error("Unexpected exception during ftp put empty file: " + e.getMessage());
//		}
//
//		return successful;
//	}
//
//	/**
//	 * Remove the specified filename from the specified target directory on the
//	 * server.
//	 * 
//	 * @param filename
//	 *            The name of the file to remove.
//	 * @param targetDirectory
//	 *            The directory path where the file should reside.
//	 * @return Boolean flag indicating success or failure.
//	 */
//	@Override
//	public boolean ftpRemoveFileFromDirectory(final String filename, final String targetDirectory) {
//
//		boolean successful = false;
//
//		final String removedFilePath = targetDirectory + "/" + filename;
//
//		try {
//
//			if (outboundChannelRemove.send(MessageBuilder.withPayload(removedFilePath).build(), ftpTimeout)) {
//
//				Message<?> msgs = output.receive(ftpTimeout);
//
//				if (msgs != null) {
//					successful = (Boolean) msgs.getPayload();
//				}
//			}
//
//		} catch (Exception e) {
//			logger.error("Unexpected exception during ftp remove: " + e.getMessage());
//		}
//
//		return successful;
//	}
//
//	/**
//	 * Move the specified filename to the specified target directory.
//	 * 
//	 * @param originalFilename
//	 *            The name of the file to move.
//	 * @param targetDirectory
//	 *            The directory path to move the file.
//	 * @return Boolean flag indicating success or failure.
//	 */
//	@Override
//	public boolean ftpMoveFileToDirectory(final String originalFilename, final String targetDirectory) {
//
//		boolean successful = false;
//
//		final String movedFilePath = targetDirectory + "/" + originalFilename;
//
//		try {
//
//			if (outboundChannelMove.send(
//					MessageBuilder.withPayload(originalFilename).setHeader(FTP_RENAME_TO_HEADER, movedFilePath).build(),
//					ftpTimeout)) {
//
//				Message<?> msgs = output.receive(ftpTimeout);
//
//				if (msgs != null) {
//					successful = (Boolean) msgs.getPayload();
//				}
//			}
//
//		} catch (Exception e) {
//			logger.error("Unexpected exception during ftp move: " + e.getMessage());
//		}
//
//		return successful;
//	}
//
//	/**
//	 * Move the specified filename to the specified target directory.
//	 * 
//	 * @param originalFilename
//	 *            The name of the file to move.
//	 * @param targetDirectory
//	 *            The directory path to move the file.
//	 * @return Boolean flag indicating success or failure.
//	 */
//	@Override
//	public boolean ftpMoveFileFromDirectoryToDirectory(final String originalFilename, final String originalDirectory,
//			final String targetDirectory) {
//
//		boolean successful = false;
//
//		final String originalFilePath = originalDirectory + "/" + originalFilename;
//		final String movedFilePath = targetDirectory + "/" + originalFilename;
//
//		try {
//
//			if (outboundChannelMove.send(
//					MessageBuilder.withPayload(originalFilePath).setHeader(FTP_RENAME_TO_HEADER, movedFilePath).build(),
//					ftpTimeout)) {
//
//				Message<?> msgs = output.receive(ftpTimeout);
//
//				if (msgs != null) {
//					successful = (Boolean) msgs.getPayload();
//				}
//			}
//
//		} catch (Exception e) {
//			logger.error("Unexpected exception during ftp move: " + e.getMessage());
//		}
//
//		return successful;
//	}
//
//	/**
//	 * Rename the specified filename with the new filename in the specified
//	 * target directory on the server.
//	 * 
//	 * @param originalFilename
//	 *            The original filename on the server.
//	 * @param newFilename
//	 *            The new filename on the server.
//	 * @param targetDirectory
//	 *            The target directory where the files reside on the server.
//	 * @return Boolean flag indicating successful rename or not.
//	 */
//	@Override
//	public boolean ftpRenameFileInDirectory(final String originalFilename, final String newFilename,
//			final String targetDirectory) {
//
//		boolean successful = false;
//
//		final String originalFilePath = targetDirectory + "/" + originalFilename;
//		final String movedFilePath = targetDirectory + "/" + newFilename;
//
//		try {
//
//			if (outboundChannelMove.send(
//					MessageBuilder.withPayload(originalFilePath).setHeader(FTP_RENAME_TO_HEADER, movedFilePath).build(),
//					ftpTimeout)) {
//
//				Message<?> msgs = output.receive(ftpTimeout);
//
//				if (msgs != null) {
//					successful = (Boolean) msgs.getPayload();
//				}
//			}
//
//		} catch (Exception e) {
//			logger.error("Unexpected exception during ftp rename: " + e.getMessage());
//		}
//
//		return successful;
//	}
//
//	/**
//	 * Get a list of files that reside in the specified directory path.
//	 * 
//	 * @param targetDirectory
//	 *            The directory path to get associated file listing.
//	 * @return Boolean flag indicating success or failure.
//	 */
//	@Override
//	public List<String> ftpGetFileListInDirectory(final String targetDirectory) {
//		return ftpGetFileListInDirectory(targetDirectory, false);
//	}
//
//	/**
//	 * Get a list of files that reside in the specified directory path.
//	 * 
//	 * @param targetDirectory
//	 *            The directory path to get associated file listing.
//	 * @param throwExceptions
//	 *            If true, any exceptions will be re-thrown after being logged.
//	 * @return Boolean flag indicating success or failure.
//	 */
//	@Override
//	public List<String> ftpGetFileListInDirectory(final String targetDirectory, boolean throwExceptions) {
//
//		try {
//
//			inboundChannelLs.send(new GenericMessage<String>(targetDirectory), ftpTimeout);
//
//			Message<?> msgs = output.receive(ftpTimeout);
//
//			@SuppressWarnings("unchecked")
//			List<String> fileL = (List<String>) msgs.getPayload();
//
//			return fileL;
//
//		} catch (Exception e) {
//			logger.error("Unexpected exception during ftp list: " + e.getMessage());
//			if (throwExceptions)
//				throw (e);
//		}
//
//		return null;
//	}
//
//	/**
//	 * Get a list of files that reside in the specified directory path that have
//	 * the specified extension. The extension check will ignore case.
//	 * 
//	 * @param targetDirectory
//	 *            The directory path to get associated file listing.
//	 * @return Boolean flag indicating success or failure.
//	 */
//	@Override
//	public List<String> ftpGetFileListWithExtensionInDirectory(final String targetDirectory, final String extension) {
//		return ftpGetFileListWithExtensionInDirectory(targetDirectory, extension, false);
//	}
//
//	/**
//	 * Get a list of files that reside in the specified directory path that have
//	 * the specified extension. The extension check will ignore case.
//	 * 
//	 * @param targetDirectory
//	 *            The directory path to get associated file listing.
//	 * @param throwExceptions
//	 *            If true, any exceptions will be re-thrown after being logged.
//	 * @return List of file names sorted by their modified dates
//	 */
//	@Override
//	public List<String> ftpGetFileListWithExtensionInDirectory(final String targetDirectory, final String extension,
//			boolean throwExceptions) {
//
//		try {
//
//			inboundChannelLsFileInfo.send(new GenericMessage<String>(targetDirectory), ftpTimeout);
//
//			Message<?> msgs = output.receive(ftpTimeout);
//
//			@SuppressWarnings("unchecked")
//			List<FileInfo<?>> fileL = (List<FileInfo<?>>) msgs.getPayload();
//
//			if ((fileL != null) && !fileL.isEmpty()) {
//				List<FileData> dataList = new ArrayList<FileData>();
//				for (FileInfo<?> file : fileL) {
//					if (file.getFilename().toUpperCase().endsWith(extension.toUpperCase())) {
//						dataList.add(new FileData(file.getFilename(), file.getModified()));
//					}
//				}
//				// Sort the list by date modified
//				Collections.sort(dataList);
//				List<String> returnL = new ArrayList<String>();
//				for (FileData fileData : dataList) {
//					returnL.add(fileData.getFileName());
//				}
//				return returnL;
//			}
//
//			return null;
//
//		} catch (Exception e) {
//			logger.error("Unexpected exception during ftp list: " + e.getMessage());
//			if (throwExceptions)
//				throw (e);
//		}
//
//		return null;
//	}
//
//	// /**
//	// * Get a list of files that reside in the specified directory path.
//	// *
//	// * @param targetDirectory
//	// * The directory path to get associated file listing.
//	// * @return FileInfo list indicating the files on the FTP server
//	// */
//	// public List<FileInfo<?>> ftpGetFileInfoListInDirectory(final String
//	// targetDirectory) {
//	// return ftpGetFileInfoListInDirectory(targetDirectory, false);
//	// }
//	//
//	// /**
//	// * Get a list of files that reside in the specified directory path.
//	// *
//	// * @param targetDirectory
//	// * The directory path to get associated file listing.
//	// * @param throwExceptions
//	// * If true, any exceptions will be re-thrown after being logged.
//	// * @return FileInfo list indicating the files on the FTP server
//	// */
//	// public List<FileInfo<?>> ftpGetFileInfoListInDirectory(final String
//	// targetDirectory, final boolean throwExceptions) {
//	// try {
//	//
//	// inboundChannelLsFileInfo.send(new
//	// GenericMessage<String>(targetDirectory), ftpTimeout);
//	//
//	// Message<?> msgs = output.receive(ftpTimeout);
//	//
//	// @SuppressWarnings("unchecked")
//	// List<FileInfo<?>> fileL = (List<FileInfo<?>>) msgs.getPayload();
//	// return fileL;
//	//
//	// } catch (Exception e) {
//	// logger.error("Unexpected exception during ftp file info list: " +
//	// e.getMessage());
//	// if (throwExceptions)
//	// throw (e);
//	// }
//	//
//	// return null;
//	// }
//	//
//	// /**
//	// * Get a list of files that reside in the specified directory path that
//	// have
//	// * the specified extension. The extension check will ignore case.
//	// *
//	// * @param targetDirectory
//	// * The directory path to get associated file listing.
//	// * @param throwExceptions
//	// * If true, any exceptions will be re-thrown after being logged.
//	// * @return FileInfo list indicating the files on the FTP server
//	// */
//	// public List<FileInfo<?>> ftpGetFileInfoListWithExtensionInDirectory(final
//	// String targetDirectory, final String extension) {
//	// return ftpGetFileInfoListWithExtensionInDirectory(targetDirectory,
//	// extension, false);
//	// }
//	//
//	// /**
//	// * Get a list of files that reside in the specified directory path that
//	// have
//	// * the specified extension. The extension check will ignore case.
//	// *
//	// * @param targetDirectory
//	// * The directory path to get associated file listing.
//	// * @param extension
//	// * The specified extension to filter for.
//	// * @param throwExceptions
//	// * If true, any exceptions will be re-thrown after being logged.
//	// * @return FileInfo list indicating the files on the FTP server
//	// */
//	// public List<FileInfo<?>> ftpGetFileInfoListWithExtensionInDirectory(
//	// final String targetDirectory, final String extension, final boolean
//	// throwExceptions) {
//	//
//	// try {
//	// inboundChannelLsFileInfo.send(new
//	// GenericMessage<String>(targetDirectory), ftpTimeout);
//	//
//	// Message<?> msgs = output.receive(ftpTimeout);
//	//
//	// @SuppressWarnings("unchecked")
//	// List<FileInfo<?>> fileL = (List<FileInfo<?>>) msgs.getPayload();
//	//
//	// if ((fileL != null) && !fileL.isEmpty()) {
//	// List<FileInfo<?>> returnL = new ArrayList<>();
//	// for (FileInfo<?> file : fileL) {
//	// if (file.getFilename().toUpperCase().endsWith(extension.toUpperCase())) {
//	// returnL.add(file);
//	// }
//	// }
//	// return returnL;
//	// }
//	//
//	// return fileL;
//	//
//	// } catch (Exception e) {
//	// logger.error("Unexpected exception during ftp list: " + e.getMessage());
//	// if (throwExceptions)
//	// throw (e);
//	// }
//	//
//	// return null;
//	// }
//
//	/**
//	 * Check if the specified filename exists in the target directory.
//	 * 
//	 * @param filename
//	 *            The name of the file to check existence.
//	 * @param targetDirectory
//	 *            The target directory path to check for the specified file.
//	 * @return Boolean flag indicating success or failure.
//	 */
//	@Override
//	public boolean ftpFileExistsInDirectory(final String filename, final String targetDirectory) {
//		return ftpFileExistsInDirectory(filename, targetDirectory, false);
//	}
//
//	/**
//	 * Check if the specified filename exists in the target directory.
//	 * 
//	 * @param filename
//	 *            The name of the file to check existence.
//	 * @param targetDirectory
//	 *            The target directory path to check for the specified file.
//	 * @param throwExceptions
//	 *            If true, any exceptions will be re-thrown after being logged.
//	 * @return Boolean flag indicating success or failure.
//	 */
//	@Override
//	public boolean ftpFileExistsInDirectory(final String filename, final String targetDirectory,
//			boolean throwExceptions) {
//
//		boolean successful = false;
//
//		List<String> fileL = ftpGetFileListInDirectory(targetDirectory, throwExceptions);
//
//		if (fileL != null) {
//			successful = fileL.contains(filename);
//		}
//
//		return successful;
//	}
//
//	/**
//	 * Get the size of the specified file or null if does not exist.
//	 * 
//	 * @param targetDirectory
//	 *            The directory path to get associated file listing.
//	 * @return Long Size of the file or null if does not exist.
//	 */
//	@Override
//	public Long ftpGetFileSizeInDirectory(final String filename, final String targetDirectory) {
//
//		Long size = null;
//
//		try {
//
//			inboundChannelSize.send(new GenericMessage<String>(targetDirectory), ftpTimeout);
//
//			Message<?> msgs = output.receive(ftpTimeout);
//
//			@SuppressWarnings("unchecked")
//			List<FileInfo<?>> fIL = (List<FileInfo<?>>) msgs.getPayload();
//
//			for (FileInfo<?> fI : fIL) {
//				String fN = fI.getFilename();
//				Long fS = fI.getSize();
//				if (filename.equals(fN)) {
//					size = fS;
//					break;
//				}
//			}
//
//		} catch (Exception e) {
//			logger.error("Unexpected exception during ftp get size: " + e.getMessage());
//		}
//
//		return size;
//	}
//
//	/**
//	 * Open a stream for the specified file.
//	 * 
//	 * @param filename
//	 *            The file to open.
//	 * @return SftpStreamSession bean that contains the session and input stream
//	 *         or null if error.
//	 * @throws Exception
//	 */
//	@Override
//	public SftpStreamSession openFileStream(final String filename, final String directory) throws Exception {
//
//		SftpStreamSession sss = null;
//
//		// Send get request to download file as stream.
//		if (inboundGetStream.send(MessageBuilder.withPayload(directory + "/" + filename).build(), ftpTimeout)) {
//
//			// If sent get request was successful, then attempt to obtain the
//			// input stream and session from the message.
//			Message<?> msgs = stream.receive(ftpTimeout);
//
//			if (msgs != null) {
//
//				// The payload from the message is the input stream with the
//				// data.
//				InputStream is = (InputStream) msgs.getPayload();
//
//				// The message header will contain the sftp session.
//				MessageHeaders mH = msgs.getHeaders();
//				Session<?> session = (Session<?>) mH.get(FTP_HEADER_FILE_REMOTE_SESSION);
//
//				if ((session != null) && (is != null)) {
//					sss = new SftpStreamSession(new SpringIntegrationSftpSessionImpl(session), is);
//				} else {
//					// Unexpected state so close resources as appropriate.
//					if (is != null) {
//						is.close();
//					} else if (session != null) {
//						session.close();
//					}
//				}
//			}
//		}
//
//		return sss;
//	}
//
//}
