package gov.va.cpss.service;


import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import gov.va.cpss.model.Role;
import gov.va.cpss.security.AuthorityUtils;

@Service
@SuppressWarnings("nls")
public class HttpUserService implements UserDetailsService {
	private static final Logger logger = Logger.getLogger(HttpUserService.class.getCanonicalName());
	@Override
	public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
		logger.info("load user role " + username);	
		
		Role r = new Role();
		r.setName(AuthorityUtils.AuthorityEnum.ROLE_ADMIN.getAuthority());
		List<Role> roles = new ArrayList<Role>();
		roles.add(r);
		Role r1 = new Role();
		r1.setName(AuthorityUtils.AuthorityEnum.ROLE_USER.getAuthority());
		roles.add(r1);
		
		Collection<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        for (Role role : roles) {
            authorities.add(new SimpleGrantedAuthority(role.getName()));
        }

       return new User(username, "", true, true, true, true, authorities);
		
		
	}
}



