package gov.va.cpss.service;

import javax.servlet.http.HttpServletRequest;

import org.springframework.security.web.authentication.preauth.RequestHeaderAuthenticationFilter;
import org.apache.commons.lang.StringUtils;

public class CbssHttpUserFilter extends RequestHeaderAuthenticationFilter {
	protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
		String preauthUsername = System.getenv("cbss.access.local");
		if (StringUtils.isNotBlank(preauthUsername))
			return preauthUsername;

		return super.getPreAuthenticatedPrincipal(request);
		
	}

}


	