package gov.va.cpss.performance;

/**
 * A stop watch with start, stop and reset functions.
 * 
 * @author Brad Pickle
 *
 */
public interface StopWatch {
	/**
	 * @return boolean indicating if the timer is currently accumulating time.
	 */
	boolean isRunning();
	
	/**
	 * Start the timer. Calling this method will not reset the elapsed time, but
	 * will cause the timer to start adding to any prior elapsed time.
	 */
	void start();

	/**
	 * Stop the timer. Causes the timer to stop accumulating elapsed time.
	 */
	void stop();

	/**
	 * Reset elapsed time to zero. Does not stop the timer, so if the timer is
	 * running then elapsed time will be set to zero but will continue to
	 * accumulate.
	 */
	void reset();

	/**
	 * Return the timer's elapsed time in milliseconds. If the timer is running,
	 * the elapsed time will include time up to the current time.
	 * 
	 * @return long elapsed time in milliseconds
	 */
	long getElapsedTime();

	/**
	 * @return String elapsed time in milliseconds
	 */
	String getElapsedTimeAsString();
}
