package gov.va.cpss.performance;

public class SimpleStopWatch implements StopWatch {

	public static final int MILLIS_IN_HOUR = 3600000;

	public static final int MILLIS_IN_MINUTE = 60000;

	public static final int MILLIS_IN_SECOND = 1000;

	private boolean isRunning = false;
	private long startTimeMillis;
	private long elapsedTimeMillis;

	@Override
	public boolean isRunning() {
		return isRunning;
	}

	@Override
	public synchronized void start() {
		if (!isRunning) {
			startTimeMillis = System.currentTimeMillis();
			isRunning = true;
		}
	}

	@Override
	public synchronized void stop() {
		if (isRunning) {
			elapsedTimeMillis += (System.currentTimeMillis() - startTimeMillis);
			isRunning = false;
		}
	}

	@Override
	public synchronized void reset() {
		elapsedTimeMillis = 0L;
		if (isRunning) {
			startTimeMillis = System.currentTimeMillis();
		}
	}

	@Override
	public synchronized long getElapsedTime() {
		return elapsedTimeMillis + (isRunning ? (System.currentTimeMillis() - startTimeMillis) : 0L);
	}

	@Override
	public String getElapsedTimeAsString() {
		return getElapsedTimeAsString(getElapsedTime());
	}

	public static String getElapsedTimeAsString(long startTimeMillis, long stopTimeMillis) {
		final long elapsedTimeMillis = (stopTimeMillis > startTimeMillis) ? (stopTimeMillis - startTimeMillis) : 0L;
		return getElapsedTimeAsString(elapsedTimeMillis);
	}

	public static String getElapsedTimeAsString(long elapsedTimeMillis) {
		long remainingMillis = elapsedTimeMillis;

		final long elapsedHours = (remainingMillis >= MILLIS_IN_HOUR) ? remainingMillis / MILLIS_IN_HOUR : 0L;
		remainingMillis -= elapsedHours * MILLIS_IN_HOUR;

		final long elapsedMinutes = (remainingMillis >= MILLIS_IN_MINUTE) ? remainingMillis / MILLIS_IN_MINUTE : 0L;
		remainingMillis -= elapsedMinutes * MILLIS_IN_MINUTE;

		final long elapsedSeconds = (remainingMillis >= MILLIS_IN_SECOND) ? remainingMillis / MILLIS_IN_SECOND : 0L;
		remainingMillis -= elapsedSeconds * MILLIS_IN_SECOND;

		String delim = "";
		final StringBuilder s = new StringBuilder();

		if (elapsedHours > 0) {
			s.append(delim).append(elapsedHours).append((elapsedHours > 1) ? " hours" : " hour");
			delim = ", ";
		}

		if (elapsedMinutes > 0) {
			s.append(delim).append(elapsedMinutes).append((elapsedMinutes > 1) ? " minutes" : " minute");
			delim = ", ";
		}

		if (elapsedSeconds > 0) {
			s.append(delim).append(elapsedSeconds).append((elapsedSeconds > 1) ? " seconds" : " second");
			delim = ", ";
		}

		s.append(delim).append(remainingMillis).append(" milliseconds");

		return s.toString();
	}

}
