package gov.va.cpss.performance;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.log4j.Logger;

public class MemoryAnalyzerImpl implements PerformanceAnalyzer {

	protected static final Logger logger = Logger.getLogger(MemoryAnalyzerImpl.class.getCanonicalName());

	protected static final long MEGABYTE = 1024L * 1024L;

	protected static long bytesToMegaBytes(final long bytes) {
		return bytes / MEGABYTE;
	}

	protected static void logTime(final String message) {
		Date date = new Date();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
		logger.info(message + ": " + sdf.format(date));
	}

	public void report(final String message) {

		logTime("Begin Memory Report (" + message + ")");

		// Get the Java runtime.
		Runtime runtime = Runtime.getRuntime();

		// Calculate the memory usage.
		long maxMemory = runtime.maxMemory();

		long totalMemory = runtime.totalMemory();

		long freeMemory = runtime.freeMemory();

		long usedMemory = totalMemory - freeMemory;

		logger.info("Max   Memory: " + bytesToMegaBytes(maxMemory) + "M");
		logger.info("Total Memory: " + bytesToMegaBytes(totalMemory) + "M");
		logger.info("Free  Memory: " + bytesToMegaBytes(freeMemory) + "M");
		logger.info("Use   Memory: " + bytesToMegaBytes(usedMemory) + "M");

		logTime("End Memory Report");
	}

}
