package gov.va.cpss.model.updatestation;

import java.beans.PropertyEditorSupport;

import org.apache.log4j.Logger;

public class ZipCodeEditor extends PropertyEditorSupport {

    private final Logger zipCodeLogger;

    public ZipCodeEditor() {
        zipCodeLogger = Logger.getLogger(this.getClass().getCanonicalName());
    }

    @Override
    public void setAsText(String text) {
        try {
        	// Need to account for trailing whitespace, because FixedLengthTokenizer trims trailing whitespace.
        	if(text.length() > 0) {
        		if(text.length() <= 5) {
        			setValue(new ZipCode(text.substring(0, Math.min(5, text.length())), "", ""));
        		}
        		else if(text.length() <= 9) {
        			setValue(new ZipCode(text.substring(0, 5), text.substring(5, Math.min(9, text.length())), ""));
        		}
        		else {
        			setValue(new ZipCode(text.substring(0,Math.min(5, text.length())), text.substring(5,9), text.substring(9,11)));
        		}
        	}
        } catch (NumberFormatException e) {
            zipCodeLogger.error("Caught exception: " + e.getMessage());
            throw (e);
        }
    }
}
