package gov.va.cpss.model.sendcbs;

import java.util.Date;

/**
 * Date class used to deal with FormatterLineAggregator not being able to handle
 * null Date objects.
 * 
 * Overrides toString() method to provide CBS date formatting MMDDYYYY or empty
 * string.
 * 
 * @author Brad Pickle
 *
 */
public class PSDate extends Date {

	private static final long serialVersionUID = 1L;

	public PSDate(long milliseconds) {
		super(milliseconds);
	}

	@Override
	public String toString() {
		if (this.getTime() == 0)
			return "";
		else
			return String.format("%tm%<td%<tY", this);
	}

}
