package gov.va.cpss.model.sendapps;

import java.io.Serializable;

import gov.va.cpss.model.ps.RecordType;
import gov.va.cpss.model.ps.Site;

/**
 * A POJO class used for outputting to the Send APPS file.
 */
//public class SendAppsPSRecord extends SendAPPSRecord implements Serializable {
@SuppressWarnings("nls")
public class SendAppsPSRecord extends Site implements Serializable, SendAPPSRecord<RecordType> {
	
	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -5817423886837963107L;

	private long totPatient;
	private int statementYear;
	
	public long getTotPatient() {
		return this.totPatient;
	}
	public void setTotPatient(long inTotPatient) {
		this.totPatient = inTotPatient;
	}
	public int getStatementYear() {
		return this.statementYear;
	}
	public void setStatementYear(int inStatementYear) {
		this.statementYear = inStatementYear;
	}

	@Override
	public String toFileOutputString() {
		return String.format("%-2s%010d%-4d%-295s",
				getType(), Long.valueOf(this.totPatient), Integer.valueOf(this.statementYear), getFiller());
	}

	@Override
	public String toString() {
		return "SendAppsPSRecord [seqNum=" + this.seqNum + ", totSeqNum=" + this.totSeqNum 
				+ ", facilityNum=" + this.facilityNum + ", facilityPhoneNum=" + this.facilityPhoneNum 
				+", totPatient=" + this.totPatient + ", statementYear=" + this.statementYear 
				+ ", processDate=," + this.processDate + "]";
	}
}
