package gov.va.cpss.model.sendapps;

import java.io.Serializable;

import gov.va.cpss.model.ps.Patient;
import gov.va.cpss.model.ps.RecordType;

@SuppressWarnings("nls")
//public class SendAppsPHRecord extends SendAPPSRecord implements Serializable {
public class SendAppsPHRecord extends Patient implements Serializable, SendAPPSRecord<RecordType> {

	/**
	 * Generated Serial Version UID
	 */
	private static final long serialVersionUID = -9050651933385609532L;

	private int sequenceNum;
	private long totAmountReceived;
	private int numOfPd;
	
	public int getSequenceNum() {
		return this.sequenceNum;
	}

	public void setSequenceNum(int inSequenceNum) {
		this.sequenceNum = inSequenceNum;
	}

	public long getTotAmountReceived() {
		return this.totAmountReceived;
	}

	public void setTotAmountReceived(long inTotAmountReceived) {
		this.totAmountReceived = inTotAmountReceived;
	}

	public int getNumOfPd() {
		return this.numOfPd;
	}

	public void setNumOfPd(int inNumOfPd) {
		this.numOfPd = inNumOfPd;
	}
	
	@Override
	public String toFileOutputString() {
		return String.format("%-2s%-17s%010d%-19s%-20s%-10s%-10s%-40s%-40s%-40s%-40s%-2s%-11s%-20s%09d%04d%-16s%-14s", 
				getType(), this.icn, Integer.valueOf(this.sequenceNum), this.accountNumber, this.lastName, this.firstName, this.middleName,
				this.address1, this.address2, this.address3, this.city, this.state, this.zipCode, this.country, Long.valueOf(this.totAmountReceived), Integer.valueOf(this.numOfPd), this.dfnStr, getFiller());
	}

	@Override
	public String toString() {
		return "SendAppsPHRecord [icn=" + this.icn +", sequenceNum=" + this.sequenceNum +", "
				+ "patientAcctNum=" + this.accountNumber + ", patientLastName=" + this.lastName 
				+ ", patientFirstName=" + this.firstName + ", patientMiddleName=" + this.middleName
				+ ", address1=" + this.address1 +", address2=" + this.address2 + ", address3=" + this.address3
				+ ", city=" + this.city + ", state=" + this.state + ", zipCode=" + this.zipCode +", countryName=" 
				+ this.country + ", totAmountReceived=" + this.totAmountReceived + ", numOfPd=" + this.numOfPd
				+ ", dfn=" + this.dfnStr + "]";
	}
}
