package gov.va.cpss.model.sendapps;

import static gov.va.cpss.model.ps.Constants.EMPTY_STRING;

import gov.va.cpss.model.ps.PSRecord;

/**
 * A base class to use for records relating to the Send APPS job.
 * 
 * 
 * Changed to interface to utilize Model.PS Framework interfaces and classes.
 * 
 * Yiping Yao
 * 
 * 07/21/2017
 * 
 */
//public abstract class SendAPPSRecord {
public interface SendAPPSRecord<Type extends Enum<Type>> extends PSRecord<Type> {
	
	/**
	 * Returns an empty String. Used by Formatter to inject Filler fields into
	 * fixed length records.
	 * 
	 * @return Empty String
	 */
	public default String getFiller() {
		return EMPTY_STRING;
	}
	
	public abstract String toFileOutputString();
}
