package gov.va.cpss.model.ps;

import java.util.Date;

import gov.va.cpss.model.CBSSAbstractModel;

/**
 * Abstract model class for StatementReceived.
 * 
 * @author Yiping Yao
 * @version 1.0 - 20161024
 */
public abstract class StatementReceived extends CBSSAbstractModel
{
    // Properties
    protected long numOfSite;
    protected long numOfStatement;
    protected long numOfPatient;
    protected Date dateReceived;
    protected String fileName;
    protected int batchRunId;

    /**
     * @return the numOfSite
     */
    public long getNumOfSite()
    {
        return this.numOfSite;
    }

    /**
     * @param inNumOfSite the numOfSite to set
     */
    public void setNumOfSite(long inNumOfSite)
    {
        this.numOfSite = inNumOfSite;
    }

    /**
     * @return the numOfStatement
     */
    public long getNumOfStatement()
    {
        return this.numOfStatement;
    }

    /**
     * @param inNumOfStatement the numOfStatement to set
     */
    public void setNumOfStatement(long inNumOfStatement)
    {
        this.numOfStatement = inNumOfStatement;
    }

    /**
     * @return the numOfPatient
     */
    public long getNumOfPatient()
    {
        return this.numOfPatient;
    }

    /**
     * @param inNumOfPatient the numOfPatient to set
     */
    public void setNumOfPatient(long inNumOfPatient)
    {
        this.numOfPatient = inNumOfPatient;
    }

    /**
     * @return the dateReceived
     */
    public Date getDateReceived()
    {
        return this.dateReceived;
    }

    /**
     * @param inDateReceived the dateReceived to set
     */
    public void setDateReceived(Date inDateReceived)
    {
        this.dateReceived = inDateReceived;
    }

    /**
     * @return the fileName
     */
    public String getFileName()
    {
        return this.fileName;
    }
    
    /**
     * @param inFileName the fileName to set
     */
    public void setFileName(String inFileName)
    {
        this.fileName = inFileName;
    }

    /**
     * @return the batchRunId
     */
    public int getBatchRunId()
    {
        return this.batchRunId;
    }

    /**
     * @param inBatchRunId the batchRunId to set
     */
    public void setBatchRunId(int inBatchRunId)
    {
        this.batchRunId = inBatchRunId;
    }

}