package gov.va.cpss.model.ps;

import java.util.Date;

import gov.va.cpss.model.AITCDollar;

/**
 * Abstract model class for Statement.
 * 
 * Copyright HPE / VA
 * January 17, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 */
public abstract class Statement extends PSAbstractModel<RecordType>
{
    // Properties
    protected long accountId;
    protected String accountIdStr;
    protected Date statementDate;
    protected Date processDate;
    protected Date printDate;
    protected long replacedStmtId;
    protected AITCDollar totalAmountReceived;

    //
    // Access Methods
    //
    /**
     * @return the accountId
     */
    public long getAccountId()
    {
        return this.accountId;
    }

    /**
     * @param inAccountId the accountId to set
     */
    public void setAccountId(long inAccountId)
    {
        this.accountId = inAccountId;
    }

    /**
     * @return the accountIdStr
     */
    public String getAccountIdStr()
    {
        return this.accountIdStr;
    }

    /**
     * @param inAccountIdStr the accountIdStr to set
     */
    public void setAccountIdStr(String inAccountIdStr)
    {
        this.accountIdStr = inAccountIdStr;
    }

    /**
     * @return the statementDate
     */
    public Date getStatementDate()
    {
        return this.statementDate;
    }

    /**
     * @param inStatementDate the statementDate to set
     */
    public void setStatementDate(Date inStatementDate)
    {
        this.statementDate = inStatementDate;
    }

    /**
     * @return the processDate
     */
    public Date getProcessDate()
    {
        return this.processDate;
    }

    /**
     * @param inProcessDate the processDate to set
     */
    public void setProcessDate(Date inProcessDate)
    {
        this.processDate = inProcessDate;
    }

    /**
     * @return the printDate
     */
    public Date getPrintDate()
    {
        return this.printDate;
    }

    /**
     * @param inPrintDate the printDate to set
     */
    public void setPrintDate(Date inPrintDate)
    {
        this.printDate = inPrintDate;
    }

    /**
     * @return the replacedStmtId
     */
    public long getReplacedStmtId()
    {
        return this.replacedStmtId;
    }

    /**
     * @param inReplacedStmtId the replacedStmtId to set
     */
    public void setReplacedStmtId(long inReplacedStmtId)
    {
        this.replacedStmtId = inReplacedStmtId;
    }

    /**
     * @return the totalAmountReceived
     */
    public AITCDollar getTotalAmountReceived()
    {
        return this.totalAmountReceived;
    }

    /**
     * @param inTotalAmountReceived the totalAmountReceived to set
     */
    public void setTotalAmountReceived(AITCDollar inTotalAmountReceived)
    {
        this.totalAmountReceived = inTotalAmountReceived;
    }
}