package gov.va.cpss.model.ps;

/**
 * 
 * Constants used by Patient Statement related processing.
 * 
 * Copyright HPE / VA
 * October 24, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
@SuppressWarnings("nls")
public final class Constants
{
    /**
     * The key to identify the input resource.
     */
    public static final String INPUT_RESOURCE_KEY = "inputResource";
    
    /**
     * The key to identify the data directory holding the input resource.
     */
    public static final String INPUT_DIRECTORY_KEY = "inputDirectory";

    /**
     * The key to identify the message output resource.
     */
    public static final String MESSAGE_RESOURCE_KEY = "messageResource";
    
    /**
     * The key to identify the message directory holding the message resource.
     */
    public static final String MESSAGE_DIRECTORY_KEY = "messageDirectory";

    /**
     * The key to identify the database primary key value for the APS/PSReceived
     * table entry associated with the job.
     */
    public static final String RECEIVED_ID_KEY = "receivedId";

    /**
     * The key to identify the database primary key value for the APS/PSSite table
     * entry associated with the currently processing APS data entry.
     */
    public static final String SITE_ID_KEY = "siteId";

    /**
     * The key to identify the database primary key value for the APS/PSPatient
     * table entry associated with the currently processing PH data entry.
     */
    public static final String PATIENT_ID_KEY = "patientId";

    /**
     * The key to identify the database primary key value for the APSMonth
     * table entry associated with the currently processing PH data entry.
     */
    public static final String MONTH_ID_KEY = "monthId";

    /**
     * The key to identify the rolling count of the total data rows read by
     * the batch job run.
     */
    public static final String TOTAL_READ_COUNT_KEY = "totalReadCount";

    /**
     * The key to identify the rolling count of the total APS/PS rows processed by
     * the batch job run.
     */
    public static final String TOTAL_SITE_COUNT_KEY = "totalSiteCount";

    /**
     * The key to identify the rolling count of the total PH rows processed by
     * the batch job run.
     */
    public static final String TOTAL_STATEMENT_COUNT_KEY = "totalStatementCount";

    /**
     * The key to identify the rolling count of the total PH rows processed by
     * the batch job run.
     */
    public static final String TOTAL_PATIENT_COUNT_KEY = "totalPatientCount";

    /**
     * The key to identify the rolling count of the total PM rows processed by
     * the batch job run.
     */
    public static final String TOTAL_MONTH_COUNT_KEY = "totalMonthCount";

    /**
     * Key to initial site count.
     */
    public static final int INITIAL_SITE_COUNT = 0;

    /**
     * Key to indicate site count.
     */
    public static final String SITE_COUNT_KEY = "siteCount";

    /**
     * Key to indicate most recent site is complete.
     */
    public static final String SITE_COMPLETE_KEY = "siteComplete";

    /**
     * Key to indicate the file is completed.
     */
    public static final String FILE_COMPLETE_KEY = "fileComplete";

    /**
     * The specified format of date fields.
     */
    public static final String DATE_FORMAT_STRING = "MMddyyyy";
    
    /**
     * The specified format of year field.
     */
    public static final String YEAR_FORMAT_STRING = "yyyy";
    
    /**
     * Data Errors
     */
    public static final String DATA_ERRORS_KEY = "dataErrors";

    /**
     * The key to populate with the number of available statements in NEW state.
     */
    public static final String AVAILABLE_CS_STATISTICS_KEY = "totalCSAvailable";

    /**
     * The key to populate with the number of generated statements in NEW state.
     */
    public static final String GENERATED_CS_STATISTICS_KEY = "totalCSGenerated";

    /**
     * The key to populate with the list of detected errors.
     */
    public static final String DETECTED_ERROR_KEY = "detectedErrors";

    /**
     * The key to populate with running count of the number of generated
     * statements in INITIAL state.
     */
    public static final String TOTAL_CS_INITIAL_COUNT_KEY = "totalCSInitialCount";

    /**
     * The key to populate with running count of the number of updated
     * statements in REPLACED state.
     */
    public static final String TOTAL_CS_REPLACED_COUNT_KEY = "totalCSReplacedCount";

    /**
     * The key to the batch job process id.
     */
    public static final String BATCH_PROCESS_ID_KEY = "batchProcessId";

    /**
     * The key to the received ids.
     */
    public static final String RECEIVED_IDS_KEY = "receivedIds";

    /**
     * The key to Error Sites
     */
    public static final String ERROR_SITES_KEY = "ErrorSites";

    // Other common constants
    public static final String LINE_FEED = "\n";
    public static final String FIELD_DELIMITER = "^";
    public static final String EMPTY_STRING = "";
    public static final double DOUBLE_ZERO = 0.0D;
    public static final long LONG_ZERO = 0L;

}