package gov.va.cpss.model.printack;

import java.util.Date;
import java.util.List;

import gov.va.cpss.model.AITCDollar;

/**
 * Bean class for the PA print ack file record.
 * 
 * @author Brad Pickle
 */
public class PAFileRecord extends PrintAckFileRecord {

	private int seqNum;
	private int totSeqNum;
	private String facilityNum;
	private int totStatement;
	private AITCDollar statementValue;
	private Date statementDate;
	private Date printDate;

	private List<ADFileRecord> printAckDetailL;

	private PrintAckRec printAckRec;

	public int getSeqNum() {
		return seqNum;
	}

	public void setSeqNum(int seqNum) {
		this.seqNum = seqNum;
	}

	public int getTotSeqNum() {
		return totSeqNum;
	}

	public void setTotSeqNum(int totSeqNum) {
		this.totSeqNum = totSeqNum;
	}

	public String getFacilityNum() {
		return facilityNum;
	}

	public void setFacilityNum(String facilityNum) {
		this.facilityNum = facilityNum;
	}

	public int getTotStatement() {
		return totStatement;
	}

	public void setTotStatement(int totStatement) {
		this.totStatement = totStatement;
	}

	public AITCDollar getStatementValue() {
		return statementValue;
	}

	public void setStatementValue(AITCDollar statementValue) {
		this.statementValue = statementValue;
	}

	public Date getStatementDate() {
		return statementDate;
	}

	public void setStatementDate(Date statementDate) {
		this.statementDate = statementDate;
	}

	public Date getPrintDate() {
		return printDate;
	}

	public void setPrintDate(Date printDate) {
		this.printDate = printDate;
	}

	public List<ADFileRecord> getPrintAckDetailL() {
		return printAckDetailL;
	}

	public void setPrintAckDetailL(List<ADFileRecord> printAckDetailL) {
		this.printAckDetailL = printAckDetailL;
	}

	public void setPrintAckDetailLWithField(DetailListField detailListField) {
		this.printAckDetailL = (detailListField == null) ? null : detailListField.getPrintAckDetailL();
	}

	public PrintAckRec getPrintAckRec() {
		return printAckRec;
	}

	public void setPrintAckRec(PrintAckRec printAckRec) {
		this.printAckRec = printAckRec;
	}

	@Override
	public String toString() {
		StringBuffer buffer = new StringBuffer();

		buffer.append("PAFileRecord [");
		buffer.append("type=").append(type);
		buffer.append("seqNum=").append(seqNum);
		buffer.append(", totSeqNum=").append(totSeqNum);
		buffer.append(", facilityNum=").append(facilityNum);
		buffer.append(", totStatement=").append(totStatement);
		buffer.append(", statementValue=").append(statementValue);
		buffer.append(", statementDate=").append(statementDate);
		buffer.append(", printDate=").append(printDate);

		buffer.append(", printAckDetailL=");
		if (printAckDetailL == null) {
			buffer.append("null");
		} else {
			buffer.append("[size=").append(printAckDetailL.size());
			if (printAckDetailL.size() > 0) {
				buffer.append(", [ ");
				String delim = "";
				for (ADFileRecord adFileRecord : printAckDetailL) {
					buffer.append(delim).append(adFileRecord);
					delim = ", ";
				}
				buffer.append(" ] ");
			}
			buffer.append("]");
		}

		buffer.append("\n printAckRec=").append(printAckRec);

		buffer.append("]");

		return buffer.toString();
	}
}
