package gov.va.cpss.model.loadbill;

import java.util.HashMap;
import java.util.Map;

/**
 * Base class for the records relating to the Load Bill Data tables.
 */
public class LoadBillRecord {
	
	public enum DataType {
		UNDEFINED("Undefined"), PU("PU"), PD("PD");

		private static final Map<String, DataType> LOOKUP = new HashMap<>();
		
		private String name;

		public String getName() {
			return name;
		}

		private DataType(String name) {
			this.name = name;
		}

		public static DataType lookupByName(String name) {
			return LOOKUP.get(name);
		}

		static {
			for (DataType t : DataType.values()) {
				LOOKUP.put(t.getName(), t);
			}
		}
	}
	
	protected DataType type;

	public DataType getType() {
		return type;
	}

	public void setType(DataType type) {
		this.type = type;
	}

	/**
	 * Returns an empty String. Used by Formatter to inject Filler fields into
	 * fixed length records.
	 * 
	 * @return Empty String
	 */
	public String getFiller() {
		return "";
	}

	@Override
	public String toString() {
		return "LoadBillRecord [type=" + type + "]";
	}
	
	
}
