package gov.va.cpss.model.loadbill;

import java.text.ParseException;

import org.apache.commons.lang.StringUtils;

import gov.va.cpss.job.loadbill.LoadBillProcessingConstants;

public class LoadBillHeaderValidator {
	
	private static final int MAX_PATIENT_NUM_LENGTH = 10;
	private static final int MAX_FACILITY_NUM_LENGTH = 5;
	private static final int MAX_PROCESS_DATE_LENGTH = 8;
	private static final int MAX_MESSAGE_NUM_LENGTH = 10;
	private static final int MAX_TOT_MSGS_LENGTH = MAX_MESSAGE_NUM_LENGTH;
	
	/**
	 * Return true if there are any validation errors and false if there are none.
	 * @param header the PU record to validate.
	 */
	public static boolean hasErrors(LoadBillHeader header) {
		if(StringUtils.isEmpty(header.getMessageNum()) ||
				header.getMessageNum().length() > MAX_MESSAGE_NUM_LENGTH ||
				!StringUtils.isNumeric(header.getMessageNum())) {
			return true;
		}
		if(StringUtils.isEmpty(header.getTotMessageNum()) ||
				header.getTotMessageNum().length() > MAX_TOT_MSGS_LENGTH ||
				!StringUtils.isNumeric(header.getTotMessageNum())) {
			return true;
		}
		if(StringUtils.isEmpty(header.getStationNum()) ||
				header.getStationNum().length() > MAX_FACILITY_NUM_LENGTH) {
			return true;
		}
		if(StringUtils.isEmpty(header.getProcessDate()) ||
				header.getProcessDate().length() != MAX_PROCESS_DATE_LENGTH) {
			return true;
		}
		// Catch an exception if the format is incorrect.
		try {
			LoadBillProcessingConstants.DATE_FORMAT.parse(header.getProcessDate());
		}
		catch(ParseException e) {
			return true;
		}
		if(StringUtils.isEmpty(header.getTotNumPatientRecords()) ||
				header.getTotNumPatientRecords().length() > MAX_PATIENT_NUM_LENGTH) {
			return true;
		}
		return false;
	}
}
