package gov.va.cpss.model.icn;

import org.apache.commons.lang.builder.HashCodeBuilder;

import gov.va.cpss.model.CBSSAbstractModel;
import gov.va.cpss.model.ProcessStatus.Status;

/**
 * A model / bean class for the VistaAcntHist database table.
 * 
 * Copyright HPE / VA
 * August 26, 2016
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
public class VistaAcntHist extends CBSSAbstractModel
{
	// Properties
	private long dfn;
	private String stationNum;
	private String newIcn;
	private String oldIcn;
	private long oldCbssAcntId;
	private long oldDfn;
	private String oldStationNum;
	private Status status;

	/**
	 * Default constructor
	 */
	public VistaAcntHist()
	{
		// Auto-generated constructor stub
	}

	/**
	 * @return the dfn
	 */
	public long getDfn()
	{
		return this.dfn;
	}

	/**
	 * @param inDfn the dfn to set
	 */
	public void setDfn(long inDfn)
	{
		this.dfn = inDfn;
	}

	/**
	 * @return the stationNum
	 */
	public String getStationNum()
	{
		return this.stationNum;
	}

	/**
	 * @param inStationNum the stationNum to set
	 */
	public void setStationNum(String inStationNum)
	{
		this.stationNum = inStationNum;
	}

	/**
	 * @return the newIcn
	 */
	public String getNewIcn()
	{
		return this.newIcn;
	}

	/**
	 * @param inNewIcn the newIcn to set
	 */
	public void setNewIcn(String inNewIcn)
	{
		this.newIcn = inNewIcn;
	}

	/**
	 * @return the oldIcn
	 */
	public String getOldIcn()
	{
		return this.oldIcn;
	}

	/**
	 * @param inOldIcn the oldIcn to set
	 */
	public void setOldIcn(String inOldIcn)
	{
		this.oldIcn = inOldIcn;
	}

	/**
	 * @return the oldCbssAcntId
	 */
	public long getOldCbssAcntId()
	{
		return this.oldCbssAcntId;
	}

	/**
	 * @param inOldCbssAcntId the oldCbssAcntId to set
	 */
	public void setOldCbssAcntId(long inOldCbssAcntId)
	{
		this.oldCbssAcntId = inOldCbssAcntId;
	}

	/**
	 * @return the oldDfn
	 */
	public long getOldDfn()
	{
		return this.oldDfn;
	}

	/**
	 * @param inOldDfn the oldDfn to set
	 */
	public void setOldDfn(long inOldDfn)
	{
		this.oldDfn = inOldDfn;
	}

	/**
	 * @return the oldStationNum
	 */
	public String getOldStationNum()
	{
		return this.oldStationNum;
	}

	/**
	 * @param inOldStationNum the oldStationNum to set
	 */
	public void setOldStationNum(String inOldStationNum)
	{
		this.oldStationNum = inOldStationNum;
	}

	/**
	 * @return the status
	 */
	public Status getStatus()
	{
		return this.status;
	}

	/**
	 * @param inStatus the status to set
	 */
	public void setStatus(Status inStatus)
	{
		this.status = inStatus;
	}

	@Override
	public boolean equals(Object obj)
	{
		if (obj == null || !(obj instanceof VistaAcntHist))
		{
			return false;
		}

		if (obj == this)
		{
			return true;
		}

		VistaAcntHist vistaAcntHist = (VistaAcntHist) obj;

		return (Long.compare(this.dfn, vistaAcntHist.getDfn()) == 0) &&
				this.stationNum.equals(vistaAcntHist.getStationNum()) &&
				this.newIcn.equals(vistaAcntHist.getNewIcn());
	}

	@Override
	public int hashCode()
	{
		return new HashCodeBuilder(17, 31).append(this.dfn).append(this.stationNum).append(this.newIcn).toHashCode();
	}
}
