package gov.va.cpss.model.icn;

import java.util.HashMap;
import java.util.Map;

/**
 * Bean class for the ICNHistoryStatus database table.
 * 
 * @author DNS  
 */
public class ICNHistoryStatus {

	public enum Status {
		UNDEFINED("UNDEFINED"), NEW("NEW"), PROCESSED("PROCESSED"), ERROR("ERROR");

		private static final Map<String, Status> LOOKUP = new HashMap<>();

		private String name;

		public String getName() {
			return name;
		}

		private Status(String name) {
			this.name = name;
		}

		public static Status lookupByName(String name) {
			return LOOKUP.get(name);
		}

		static {
			for (Status s : Status.values()) {
				LOOKUP.put(s.getName(), s);
			}
		}
	}

	private int id;
	private String name;
	private String description;
	private Status status = Status.UNDEFINED;

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}

}
