package gov.va.cpss.model.fps;

import java.io.Serializable;

import gov.va.cpss.cobol.Money;

/**
 * Bean class for the PV CBS file record.
 * 
 * @author Brad Pickle
 */
public class PSSiteStmt extends PSRecord implements Serializable {

	private static final long serialVersionUID = 1L;

	private String facilityNum;
	private Money stationTotalAmount;
	private int numOfLines;
	private String patientAccount;
	private long dfnNumber;
	private String icnNumber;

	public String getFacilityNum() {
		return facilityNum;
	}

	public void setFacilityNum(String facilityNum) {
		this.facilityNum = facilityNum;
	}

	public Money getStationTotalAmount() {
		return stationTotalAmount;
	}

	public void setStationTotalAmount(Money stationTotalAmount) {
		this.stationTotalAmount = stationTotalAmount;
	}

	public int getNumOfLines() {
		return numOfLines;
	}

	public void setNumOfLines(int numOfLines) {
		this.numOfLines = numOfLines;
	}

	public String getPatientAccount() {
		return patientAccount;
	}

	public void setPatientAccount(String patientAccount) {
		this.patientAccount = patientAccount;
	}

	public long getDfnNumber() {
		return dfnNumber;
	}

	public void setDfnNumber(long dfnNumber) {
		this.dfnNumber = dfnNumber;
	}

	public String getIcnNumber() {
		return icnNumber;
	}

	public void setIcnNumber(String icnNumber) {
		this.icnNumber = icnNumber;
	}

	@Override
	public String toString() {
		return "PV Site [facilityNum=" + facilityNum + ", stationTotalAmount=" + stationTotalAmount + ", numOfLines="
				+ numOfLines + ", patientAccount=" + patientAccount + ", dfnNumber=" + dfnNumber + ", icnNumber="
				+ icnNumber + "]";
	}

}
