package gov.va.cpss.model.fps;

import java.io.Serializable;
import java.util.Date;

import gov.va.cpss.cobol.Money;
import gov.va.cpss.model.CBSSAuditDates;

/**
 * Bean class for the PSSite database table.
 * 
 * @author DNS   
 */
public class PSSite extends PSRecord implements CBSSAuditDates, Serializable {

	private static final long serialVersionUID = 1L;

	private long id;
	private long psReceivedId;
	private int seqNum;
	private int totSeqNum;
	private String facilityNum;
	private String facilityPhoneNum;
	private int totStatement;
	private Money statementVal;
	private Date statementDate;
	private Date processDate;
	private DataType statementType = DataType.P1;
	private String createdBy;
	private Date createdDate;
	private String modifiedBy;
	private Date modifiedDate;

	public PSSite() {
	}

	public PSSite(final long id) {
		this.id = id;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public long getPsReceivedId() {
		return psReceivedId;
	}

	public void setPsReceivedId(long psReceivedId) {
		this.psReceivedId = psReceivedId;
	}

	public int getSeqNum() {
		return seqNum;
	}

	public void setSeqNum(int seqNum) {
		this.seqNum = seqNum;
	}

	public int getTotSeqNum() {
		return totSeqNum;
	}

	public void setTotSeqNum(int totSeqNum) {
		this.totSeqNum = totSeqNum;
	}

	public String getFacilityNum() {
		return facilityNum;
	}

	public void setFacilityNum(String facilityNum) {
		this.facilityNum = facilityNum;
	}

	public String getFacilityPhoneNum() {
		return facilityPhoneNum;
	}

	public void setFacilityPhoneNum(String facilityPhoneNum) {
		this.facilityPhoneNum = facilityPhoneNum;
	}

	public int getTotStatement() {
		return totStatement;
	}

	public void setTotStatement(int totStatement) {
		this.totStatement = totStatement;
	}

	public Money getStatementVal() {
		return statementVal;
	}

	public void setStatementVal(Money statementVal) {
		this.statementVal = statementVal;
	}

	public Date getStatementDate() {
		return statementDate;
	}

	public void setStatementDate(Date statementDate) {
		this.statementDate = statementDate;
	}

	public Date getProcessDate() {
		return processDate;
	}

	public void setProcessDate(Date processDate) {
		this.processDate = processDate;
	}

	public DataType getStatementType() {
		return statementType;
	}

	public void setStatementType(DataType statementType) {
		this.statementType = statementType;
	}

	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public String getModifiedBy() {
		return modifiedBy;
	}

	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	@Override
	public String toString() {
		return "Site [id=" + id + ", psReceivedId=" + psReceivedId + ", seqNum=" + seqNum + ", totSeqNum=" + totSeqNum
				+ ", facilityNum=" + facilityNum + ", facilityPhoneNum=" + facilityPhoneNum + ", totStatement="
				+ totStatement + ", statementVal=" + statementVal + ", statementDate=" + statementDate
				+ ", processDate=" + processDate + ", statementType=" + statementType + ", createdBy=" + createdBy
				+ ", createdDate=" + createdDate + ", modifiedBy=" + modifiedBy + ", modifiedDate=" + modifiedDate
				+ "]";
	}

}
