package gov.va.cpss.model.cbs;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import gov.va.cpss.cobol.Money;
import gov.va.cpss.model.CBSSAuditDates;

/**
 * Bean class for the CBSStmt database table.
 * 
 * @author DNS   
 */
public class CBSStmt implements CBSSAuditDates, Serializable {

	private static final long serialVersionUID = 1L;

	private long id;
	private long messageId;
	private long accountId;
	private String acntNumDisp;
	private Money amountDue;
	private Money prevBalance;
	private Money totalCharges;
	private Money totalCredits;
	private Money newBalance;
	private boolean lateStmtMsg;
	private Date statementDate;
	private Date processDate;
	private long batchRunId;
	private int statusId;
	private long replacedStmtId;
	private long printAckId;
	private Date printDate;
	private String createdBy;
	private Date createdDate;
	private String modifiedBy;
	private Date modifiedDate;

	private List<CBSSiteStmt> siteStmtL;

	public CBSStmt(final long accountId) {
		this.accountId = accountId;
	}

	public CBSStmt(final long accountId, final int statusId) {
		this(accountId);
		this.statusId = statusId;
	}

	public CBSStmt(final long batchRunId, final long accountId, final int statusId) {
		this(accountId, statusId);
		this.batchRunId = batchRunId;
	}

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public long getMessageId() {
		return messageId;
	}

	public void setMessageId(long messageId) {
		this.messageId = messageId;
	}

	public long getAccountId() {
		return accountId;
	}

	public void setAccountId(long accountId) {
		this.accountId = accountId;
	}

	public String getAcntNumDisp() {
		return acntNumDisp;
	}

	public void setAcntNumDisp(String acntNumDisp) {
		this.acntNumDisp = acntNumDisp;
	}

	public Money getAmountDue() {
		return amountDue;
	}

	public void setAmountDue(Money amountDue) {
		this.amountDue = amountDue;
	}

	public Money getPrevBalance() {
		return prevBalance;
	}

	public void setPrevBalance(Money prevBalance) {
		this.prevBalance = prevBalance;
	}

	public Money getTotalCharges() {
		return totalCharges;
	}

	public void setTotalCharges(Money totalCharges) {
		this.totalCharges = totalCharges;
	}

	public Money getTotalCredits() {
		return totalCredits;
	}

	public void setTotalCredits(Money totalCredits) {
		this.totalCredits = totalCredits;
	}

	public Money getNewBalance() {
		return newBalance;
	}

	public void setNewBalance(Money newBalance) {
		this.newBalance = newBalance;
	}

	public boolean getLateStmtMsg() {
		return lateStmtMsg;
	}

	public void setLateStmtMsg(boolean lateStmtMsg) {
		this.lateStmtMsg = lateStmtMsg;
	}

	public Date getStatementDate() {
		return statementDate;
	}

	public void setStatementDate(Date statementDate) {
		this.statementDate = statementDate;
	}

	public Date getProcessDate() {
		return processDate;
	}

	public void setProcessDate(Date processDate) {
		this.processDate = processDate;
	}

	public long getBatchRunId() {
		return batchRunId;
	}

	public void setBatchRunId(long batchRunId) {
		this.batchRunId = batchRunId;
	}

	public int getStatusId() {
		return statusId;
	}

	public void setStatusId(int statusId) {
		this.statusId = statusId;
	}

	public long getReplacedStmtId() {
		return replacedStmtId;
	}

	public void setReplacedStmtId(long replacedStmtId) {
		this.replacedStmtId = replacedStmtId;
	}

	public long getPrintAckId() {
		return printAckId;
	}

	public void setPrintAckId(long printAckId) {
		this.printAckId = printAckId;
	}

	public Date getPrintDate() {
		return printDate;
	}

	public void setPrintDate(Date printDate) {
		this.printDate = printDate;
	}

	@Override
	public String getCreatedBy() {
		return createdBy;
	}

	@Override
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Override
	public Date getCreatedDate() {
		return createdDate;
	}

	@Override
	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	@Override
	public String getModifiedBy() {
		return modifiedBy;
	}

	@Override
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	@Override
	public Date getModifiedDate() {
		return modifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public List<CBSSiteStmt> getSiteStmtL() {
		return siteStmtL;
	}

	public void setSiteStmtL(List<CBSSiteStmt> siteStmtL) {
		this.siteStmtL = siteStmtL;
	}

	public CBSSiteStmt getPrimarySiteStmt() {
		if (siteStmtL != null) {
			for (CBSSiteStmt cbsSiteStmt : siteStmtL) {
				if ((cbsSiteStmt.getIsPrimary() != null) && cbsSiteStmt.getIsPrimary().isTrue()) {
					return cbsSiteStmt;
				}
			}
		}

		return null;
	}

	public CBSSiteStmt getPrimaryAddressSiteStmt() {
		if (siteStmtL != null) {
			for (CBSSiteStmt cbsSiteStmt : siteStmtL) {
				if ((cbsSiteStmt.getIsPrimaryAddress() != null) && cbsSiteStmt.getIsPrimaryAddress().isTrue()) {
					return cbsSiteStmt;
				}
			}
		}

		return null;
	}

	@Override
	public String toString() {
		return "CBSStmt [id=" + id + ", messageId=" + messageId + ", accountId=" + accountId + ", acntNumDisp="
				+ acntNumDisp + ", amountDue=" + amountDue.getDoubleAsString() + ", prevBalance="
				+ prevBalance.getDoubleAsString() + ", totalCharges=" + totalCharges.getDoubleAsString()
				+ ", totalCredits=" + totalCredits.getDoubleAsString() + ", newBalance="
				+ newBalance.getDoubleAsString() + ", lateStmtMsg=" + lateStmtMsg + ", statementDate=" + statementDate
				+ ", processDate=" + processDate + ", batchRunId=" + batchRunId + ", statusId=" + statusId
				+ ", replacedStmtId=" + replacedStmtId + ", printAckId=" + printAckId + ", printDate=" + printDate
				+ ", createdBy=" + createdBy + ", createdDate=" + createdDate + ", modifiedBy=" + modifiedBy
				+ ", modifiedDate=" + modifiedDate + "]";
	}

	public static String createAcntNumDisp(CBSStmt cbsStmt) {
		if (cbsStmt == null)
			return "";

		final CBSSiteStmt cbsSiteStmt = cbsStmt.getPrimarySiteStmt();

		final String stationNum = (cbsSiteStmt == null) ? "" : cbsSiteStmt.getStationNum().trim();

		final CBSSitePatient cbsSitePatient = (cbsSiteStmt == null) ? null : cbsSiteStmt.getSitePatient();

		final String oldAcntNum = (cbsSitePatient == null) ? null : cbsSitePatient.getOldAcntNum();

		String lastName = ((oldAcntNum == null) || (oldAcntNum.length() < (stationNum.length() + 9))) ? ""
				: oldAcntNum.substring(stationNum.length() + 9);

		return String.format("%-3.3s%010d%-5.5s", stationNum, cbsStmt.accountId, lastName);
	}

}
