package gov.va.cpss.model.cbs;

import java.util.HashMap;
import java.util.Map;

public class CBSRecord {
	public enum DataType {
		UNDEFINED("Undefined"), PS("PS"), PH("PH"), PD("PD"), PV("PV"), P1("P1");

		private static final Map<String, DataType> LOOKUP = new HashMap<>();

		private String name;

		public String getName() {
			return name;
		}

		private DataType(String name) {
			this.name = name;
		}

		public static DataType lookupByName(String name) {
			return LOOKUP.get(name);
		}

		static {
			for (DataType t : DataType.values()) {
				LOOKUP.put(t.getName(), t);
			}
		}
	}

	protected DataType type;

	public DataType getType() {
		return type;
	}

	public void setType(DataType type) {
		this.type = type;
	}


}
