package gov.va.cpss.model.cbs;

import java.util.Date;

import gov.va.cpss.model.CBSSAuditDates;

/**
 * Bean class for the CBSMessage database table.
 * 
 * @author DNS   
 */
public class CBSMessage implements CBSSAuditDates {

	private long id;
	private String fileName;
	private long batchRunId;
	private int statusId;
	private String createdBy;
	private Date createdDate;
	private String modifiedBy;
	private Date modifiedDate;

	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getFileName() {
		return fileName;
	}
	
	public String getCBSFileName() {
		if (fileName == null) return null;
		
		int commaPos = fileName.indexOf(',');
		
		if (commaPos < 0) return null;
		
		return fileName.substring(0, commaPos);
	}
	
	public String getSBSFileName() {
		if (fileName == null) return null;
		
		int commaPos = fileName.indexOf(',');
		
		if (commaPos < 0) return null;
		
		return fileName.substring(commaPos + 1);		
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	public long getBatchRunId() {
		return batchRunId;
	}

	public void setBatchRunId(long batchRunId) {
		this.batchRunId = batchRunId;
	}

	public int getStatusId() {
		return statusId;
	}

	public void setStatusId(int statusId) {
		this.statusId = statusId;
	}

	@Override
	public String getCreatedBy() {
		return createdBy;
	}

	@Override
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Override
	public Date getCreatedDate() {
		return createdDate;
	}

	@Override
	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	@Override
	public String getModifiedBy() {
		return modifiedBy;
	}

	@Override
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}

	@Override
	public Date getModifiedDate() {
		return modifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

}
