package gov.va.cpss.model.appsprintack;

import java.util.Date;
import java.util.List;

import gov.va.cpss.model.BatchRunProcess;


/**
 * Bean class for the PA print ack file record.
 * TODO
 * 
 */
public class APPSPAFileRecord extends AppsPrintAckFileRecord {

	private int seqNum;
	private String totSeqNum;
	private int totStatement;
	private int statementYear;
	private Date printDate;

	private List<APPSADFileRecord> printAckDetailL;

	private BatchRunProcess batchRunProcess;

	public int getSeqNum() {
		return seqNum;
	}

	public void setSeqNum(int seqNum) {
		this.seqNum = seqNum;
	}

	public String getTotSeqNum() {
		return totSeqNum;
	}

	public void setTotSeqNum(String totSeqNum) {
		this.totSeqNum = totSeqNum;
	}

	public int getTotStatement() {
		return totStatement;
	}

	public void setTotStatement(int totStatement) {
		this.totStatement = totStatement;
	}

	public int getStatementYear() {
		return statementYear;
	}

	public void setStatementYear(int statementYear) {
		this.statementYear = statementYear;
	}

	public Date getPrintDate() {
		return printDate;
	}

	public void setPrintDate(Date printDate) {
		this.printDate = printDate;
	}

	public List<APPSADFileRecord> getPrintAckDetailL() {
		return printAckDetailL;
	}

	public void setPrintAckDetailL(List<APPSADFileRecord> printAckDetailL) {
		this.printAckDetailL = printAckDetailL;
	}

	public void setPrintAckDetailLWithField(AppsDetailListField detailListField) {
		this.printAckDetailL = (detailListField == null) ? null : detailListField.getPrintAckDetailL();
	}

	public BatchRunProcess getBatchRunProcess() {
		return batchRunProcess;
	}

	public void setBatchRunProcess(BatchRunProcess batchRunProcess) {
		this.batchRunProcess = batchRunProcess;
	}

	@Override
	public String toString() {
		StringBuffer buffer = new StringBuffer();

		buffer.append("APPSPAFileRecord [");
		buffer.append("type=").append(type);
		buffer.append("seqNum=").append(seqNum);
		buffer.append(", totSeqNum=").append(totSeqNum);
		buffer.append(", totStatement=").append(totStatement);
		buffer.append(", statementYear=").append(statementYear);
		buffer.append(", printDate=").append(printDate);

		buffer.append(", printAckDetailL=");
		if (printAckDetailL == null) {
			buffer.append("null");
		} else {
			buffer.append("[size=").append(printAckDetailL.size());
			if (printAckDetailL.size() > 0) {
				buffer.append(", [ ");
				String delim = "";
				for (APPSADFileRecord adFileRecord : printAckDetailL) {
					buffer.append(delim).append(adFileRecord);
					delim = ", ";
				}
				buffer.append(" ] ");
			}
			buffer.append("]");
		}

		buffer.append("\n batchRunProcess=").append(batchRunProcess);

		buffer.append("]");

		return buffer.toString();
	}
}
