package gov.va.cpss.model.apps;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import gov.va.cpss.model.ps.SiteStatement;

/**
 * Model class for the APSSiteStmt database table.
 * 
 * Copyright HPE / VA
 * January 17, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 */
@SuppressWarnings("nls")
public class APSSiteStmt extends SiteStatement implements Serializable
{
    /**
     * Generated Serial Version UID
     */
    private static final long serialVersionUID = -5059270028344046789L;

    // Properties
    private Date lastBillPrepDate;
    private boolean arAddress;
    private boolean primary;
    private boolean primaryAddress;

    private APSSitePatient patient;
    private List<APSPayment> payments;

    //
    // Access Methods
    //
    /**
     * @return the lastBillPrepDate
     */
    public Date getLastBillPrepDate()
    {
        return this.lastBillPrepDate;
    }

    /**
     * @param inLastBillPrepDate the lastBillPrepDate to set
     */
    public void setLastBillPrepDate(Date inLastBillPrepDate)
    {
        this.lastBillPrepDate = inLastBillPrepDate;
    }

    /**
     * @return the arAddress
     */
    public boolean isArAddress()
    {
        return this.arAddress;
    }

    /**
     * @param inArAddress the arAddress to set
     */
    public void setArAddress(boolean inArAddress)
    {
        this.arAddress = inArAddress;
    }

    /**
     * @return the primary
     */
    public boolean isPrimary()
    {
        return this.primary;
    }

    /**
     * @param inPrimary the primary to set
     */
    public void setPrimary(boolean inPrimary)
    {
        this.primary = inPrimary;
    }

    /**
     * @return the primaryAddress
     */
    public boolean isPrimaryAddress()
    {
        return this.primaryAddress;
    }

    /**
     * @param inPrimaryAddress the primaryAddress to set
     */
    public void setPrimaryAddress(boolean inPrimaryAddress)
    {
        this.primaryAddress = inPrimaryAddress;
    }

    /**
     * @return the patient
     */
    public APSSitePatient getPatient()
    {
        return this.patient;
    }

    /**
     * @param inPatient the patient to set
     */
    public void setPatient(APSSitePatient inPatient)
    {
        this.patient = inPatient;
    }

    /**
     * @return the payments
     */
    public List<APSPayment> getPayments()
    {
        return this.payments;
    }

    /**
     * @param inPayments the payments to set
     */
    public void setPayments(List<APSPayment> inPayments)
    {
        this.payments = inPayments;
    }

    @Override
    public String toString() {
        return  "APSSiteStmt [id=" + this.id + ", stmtId=" + this.statementId + ", stationNum=" + getFacilityNum() + ", stationPhoneNum=" + getFacilityPhoneNum() +
                ", stmtYear=" + this.statementDate + ", processDate=" + this.processDate + ", totalAmntRcvd=" + this.totalAmountReceived +
                ", arAddressFlag=" + this.arAddress + ", isPrimary=" + this.primary + ", isPrimaryAddress=" + this.primaryAddress +
                ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", modifiedBy=" + this.modifiedBy + ", modifiedDate=" + this.modifiedDate + "]";
    }

}
