package gov.va.cpss.model.apps;

import java.io.Serializable;

import gov.va.cpss.model.ps.Patient;

/**
 * Model class for APSSitePatient database table.
 * 
 * Copyright HPE / VA
 * January 17, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 *
 */
@SuppressWarnings("nls")
public class APSSitePatient extends Patient implements Serializable
{
    /**
     * Generated Serial Version UID
     */
    private static final long serialVersionUID = 696268181235648945L;

    // Properties
    private long siteStmtId;

    //
    // Constructors
    //
    public APSSitePatient()
    {
        super();
    }

    public APSSitePatient(final Patient patient)
    {
        super(patient);
    }


    //
    // Access Methods
    //
    /**
     * @return the siteStmtId
     */
    public long getSiteStmtId()
    {
        return this.siteStmtId;
    }


    /**
     * @param inSiteStmtId the siteStmtId to set
     */
    public void setSiteStmtId(long inSiteStmtId)
    {
        this.siteStmtId = inSiteStmtId;
    }


    @Override
    public String toString()
    {
        return  "APSSitePatient [id=" + this.id + ", siteStmtId=" + this.siteStmtId +
                ", icn=" + this.icn + ", dfn=" + this.dfn + ", oldAcntNum=" + this.accountNumber +
                ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", middleName=" + this.middleName +
                ", address1=" + this.address1 + ", address2=" + this.address2 + ", address3=" + this.address3 +
                ", city=" + this.city + ", state=" + this.state + ", zipCode=" + this.zipCode + ", country=" + this.country +
                ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", modifiedBy=" + this.modifiedBy + ", modifiedDate=" + this.modifiedDate + "]";
    }
}
