package gov.va.cpss.model.apps;

import java.io.Serializable;
import java.time.Month;
import java.util.Objects;

import gov.va.cpss.model.AITCDollar;
import gov.va.cpss.model.ps.Transaction;

/**
 * Model class for the APSPayment database table.
 * 
 * Copyright HPE / VA
 * January 17, 2017
 * 
 * @author Yiping Yao
 * @version 1.0.0
 */
@SuppressWarnings("nls")
public class APSPayment extends Transaction implements Serializable
{
    /**
     * Generated Serial Version UID 
     */
    private static final long serialVersionUID = -838090469192559811L;

    // Properties
    private long siteStmtId;
    private Month month;

    //
    // Constructors
    //
    public APSPayment()
    {
        super();
    }

    public APSPayment(long inId)
    {
        this.id = inId;
    }

    public APSPayment(final Transaction inTransaction)
    {
        super(inTransaction);
    }

    /**
     * @return the siteStmtId
     */
    public long getSiteStmtId()
    {
        return this.siteStmtId;
    }

    /**
     * @param inSiteStmtId the siteStmtId to set
     */
    public void setSiteStmtId(long inSiteStmtId)
    {
        this.siteStmtId = inSiteStmtId;
    }

    /**
     * @return the month
     */
    public Month getMonth()
    {
        return (this.month == null) ? parseMonth(this.datePosted) : this.month;
    }

    /**
     * @param inMonth the month to set
     */
    public void setMonth(Month inMonth)
    {
        this.month = inMonth;
    }
    
    @Override
    public void setTransactionAmountStr(String inTransactionAmountStr)
    {
        this.transactionAmountStr = inTransactionAmountStr;

        if (Objects.nonNull(this.transactionAmountStr) && !this.transactionAmountStr.isEmpty())
        {
            this.transactionAmount = AITCDollar.fromStringWithoutSign(this.transactionAmountStr);
        }
    }

    @Override
    public String toString()
    {
        return  "APSPayment [id=" + this.id + ", siteStmtId=" + this.siteStmtId + ", month=" + this.month.name() + ", datePosted=" + this.datePosted + 
                ", transAmount=" + this.transactionAmount + ", transAmountRaw" + this.transactionAmountStr +
                ", createdBy=" + this.createdBy + ", createdDate=" + this.createdDate + ", modifiedBy=" + this.modifiedBy + ", modifiedDate=" + this.modifiedDate + "]";
    }

}
