package gov.va.cpss.model.apps;

import static gov.va.cpss.model.ps.Constants.DATE_FORMAT_STRING;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import org.apache.commons.lang.StringUtils;

import gov.va.cpss.model.AITCDollar;

import gov.va.cpss.model.ps.RecordType;
import gov.va.cpss.model.ps.Transaction;

/**
 * Model class for APSDetails.
 * 
 * @author Yiping Yao
 * @version 1.0 - 20161019
 *
 */
@SuppressWarnings("nls")
public class APSDetails extends Transaction implements Serializable, APSRecord<RecordType>
{
    /**
     * Generated Serial Version UID 
     */
    private static final long serialVersionUID = 6760598995433288859L;

    // Constants - Field Lengths
    public static final int MAX_TRANS_AMOUNT_LENGTH = 10;

    // Properties
    private long apsPatientId;


    //
    // Constructors
    //
    public APSDetails()
    {
        super();
    }

    public APSDetails(final Transaction inTransaction)
    {
        super(inTransaction);
    }


    //
    // Access Methods
    //
    /**
     * @return the apsPatientId
     */
    public long getApsPatientId()
    {
        return this.apsPatientId;
    }

    /**
     * @param inApsPatientId the apsPatientId to set
     */
    public void setApsPatientId(long inApsPatientId)
    {
        this.apsPatientId = inApsPatientId;
    }

    /**
     * @param inTransactionAmountStr the transactionAmountStr to set
     */
    @Override
    public void setTransactionAmountStr(String inTransactionAmountStr)
    {
        this.transactionAmountStr = inTransactionAmountStr;

        if (this.transactionAmountStr != null && !this.transactionAmountStr.isEmpty())
        {
            this.transactionAmount = AITCDollar.fromStringWithoutSign(this.transactionAmountStr);
        }
    }

    @Override
    public boolean isValid()
    {
        boolean isValid = true;
        StringBuffer strBuffer = new StringBuffer();

        // Optional
        if (!StringUtils.isEmpty(this.datePostedStr))
        {
            if (this.datePostedStr.length() != MAX_DATE_LENGTH)
            {
                strBuffer.append("datePosted is invalid (PD002). ");
                isValid = false;
            }

            // Catch an exception if the format is incorrect.
            try
            {
                new SimpleDateFormat(DATE_FORMAT_STRING).parse(this.datePostedStr);
            }
            catch(@SuppressWarnings("unused") ParseException e)
            {
                strBuffer.append("datePosted is invalid (PD002). ");
                isValid = false;
            }
        }

        if (StringUtils.isEmpty(this.transactionAmountStr) ||
            this.transactionAmountStr.length() > MAX_TRANS_AMOUNT_LENGTH ||
            !AITCDollar.isAITCDollarFormatWithoutSign(this.transactionAmountStr))
        {
            strBuffer.append("transactionAmount is invalid (PD003). ");
            isValid = false;
        }

        if (!isValid)
        {
            this.message = strBuffer.toString();
        }

        return isValid;
    }

    @Override
    public String toString()
    {
        return String.format("APS Details (%s) [datePostedStr=%s, transactionAmountStr=%s]" + " Message: %s",
                             this.type, this.datePostedStr, this.transactionAmountStr,
                             (this.message == null ? "none" : this.message));
    }

}
