package gov.va.cpss.model;

import java.util.HashMap;
import java.util.Map;

/**
 * Bean class for the ProcStatus database table.
 * 
 */
public class ProcessStatus {
	
	public enum Status {
		INITIAL("INITIAL"),
		NEW("NEW"),
		PROCESSED("PROCESSED"),
		SENT("SENT"),
		ACK("ACK"),
		REPLACED("REPLACED"),
		SUCCESS("SUCCESS"),
		ERROR("ERROR"),
		OTHER("OTHER"),
		UNDEFINED("UNDEFINED");
		
		private String name;
		private static final Map<String, Status> LOOKUP = new HashMap<>();
		
		private Status(String name) {
			this.name = name;
		}
		
		public String getName() {
			return this.name;
		}
		
		public static Status lookupByName(String name) {
			return LOOKUP.get(name);
		}

		static {
			for (Status s : Status.values()) {
				LOOKUP.put(s.getName(), s);
			}
		}
	}
	
	private int id;
	private String name;
	private String description;
	private Status status = Status.UNDEFINED;

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(Status status) {
		this.status = status;
	}
}
