package gov.va.cpss.model;

import java.beans.PropertyEditorSupport;
import java.util.IllegalFormatException;

import org.apache.log4j.Logger;

/**
 * Custom property editor used by BeanWrapperFieldSetMapper to set BooleanChar
 * enum during batch processing processing of FixedLengthTokenizer of
 * FlatFileItemReader.
 * 
 * @author DNS  
 */
public class BooleanCharEditor extends PropertyEditorSupport {

    private final Logger editorLogger;

    public BooleanCharEditor() {
    	editorLogger = Logger.getLogger(this.getClass().getCanonicalName());
    }

    @Override
    public void setAsText(String text) {
        try {
            setValue(BooleanChar.from(text));
        } catch (IllegalFormatException e) {
        	editorLogger.error("Caught exception: " + e.getMessage());
            throw (e);
        }
    }
}
