package gov.va.cpss.model;

import java.util.HashMap;
import java.util.Map;

public class BatchType {

	public enum JobType {
		UNDEFINED("Undefined"), MANUAL("Manual"), SPECIFIED("Specified"), DAILY("Daily"), SCHEDULED("Scheduled");

		private static final Map<String, JobType> LOOKUP = new HashMap<String, JobType>();

		private String name;

		public String getName() {
			return name;
		}

		private JobType(String name) {
			this.name = name;
		}

		public static JobType lookupByName(String name) {
			return LOOKUP.get(name);
		}

		static {
			for (JobType t : JobType.values()) {
				LOOKUP.put(t.getName(), t);
			}
		}
	}

	private int id;
	private String name;
	private String description;
	private JobType jobType = JobType.UNDEFINED;

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public JobType getJobType() {
		return jobType;
	}

	public void setJobType(JobType jobType) {
		this.jobType = jobType;
	}
}
