package gov.va.cpss.model;

import java.util.HashMap;
import java.util.Map;

public class BatchSrcType {
	public enum SrcType {
		UNDEFINED("Undefined"), CBS("CBS"), APS("APS");
		
		private static final Map<String, SrcType> LOOKUP = new HashMap<String, SrcType>();
		
		private String name;
		
		public String getName() {
			return name;
		}
		
		private SrcType(String name) {
			this.name= name;
		}
		
		public static SrcType lookupByName(String name) {
			return LOOKUP.get(name);
		}
		
		static {
			for (SrcType t : SrcType.values()) {
				LOOKUP.put(t.getName(), t);
			}
		}
	}
	
	private int id;
	private String name;
	private String description;
	private SrcType srcType = SrcType.UNDEFINED;
	
	public int getId() {
		return id;
	}
	
	public void setId(int id) {
		this.id = id;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public String getDescription() {
		return description;
	}
	
	public void setDescription(String description) {
		this.description = description;
	}
	
	public SrcType getSrcType() {
		return srcType;
	}
	
	public void setSrcType(SrcType srcType) {
		this.srcType = srcType;
	}	
	
}
