package gov.va.cpss.model;

public class BatchJob {

	private int id;
	private String name;
	private String description;
	private String email;
	private String schedule;
	private int typeId;
	private int sourceType;
	private String scheduleDate;
	private BatchConfig batchConfig;

	private BatchType batchType;

	public BatchJob() {
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getSchedule() {
		// Only strip leading zero if second index is not :.
		if(schedule != null) {
			if ((schedule.indexOf("0") == 0) && (schedule.indexOf(":") != 1)) {
				return schedule.substring(1);
			}
		}
		return schedule;
	}

	public void setSchedule(String schedule) {
		this.schedule = schedule;
	}

	public int getTypeId() {
		return typeId;
	}

	public void setTypeId(int typeId) {
		this.typeId = typeId;
	}

	public BatchType getBatchType() {
		return batchType;
	}

	public void setBatchType(BatchType batchType) {
		this.batchType = batchType;
	}

	public int getSourceType() {
		return sourceType;
	}

	public void setSourceType(int sourceType) {
		this.sourceType = sourceType;
	}

	public String getScheduleDate() {
		return scheduleDate;
	}

	public void setScheduleDate(String scheduleDate) {
		this.scheduleDate = scheduleDate;
	}

	public BatchConfig getBatchConfig() {
		return batchConfig;
	}

	public void setBatchConfig(BatchConfig batchConfig) {
		this.batchConfig = batchConfig;
	}

	public String formatScheduleDate(){
		String format = "";
		if (batchType.getJobType().equals(BatchType.JobType.SCHEDULED)){
			format += BatchConfig.formatDateForDisplay(batchConfig.getRangeStart());			
			format +=" to ";
			format += BatchConfig.formatDateForDisplay(batchConfig.getRangeEnd());
		}
		return format;
	}
	

}
