package gov.va.cpss.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

public class BatchConfig {

	private int id;
	private int batchJobId;
	@DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
	private Date rangeStart;
	@DateTimeFormat(iso = DateTimeFormat.ISO.DATE)
	private Date rangeEnd;
	private String other;

	public BatchConfig() {
	}

	public int getId() {
		return id;
	}

	public void setId(int id) {
		this.id = id;
	}
	public int getBatchJobId() {
		return batchJobId;
	}

	public void setBatchJobId(int batchJobId) {
		this.batchJobId = batchJobId;
	}

	public Date getRangeStart() {
		return rangeStart;
	}

	public void setRangeStart(Date rangeStart) {
		this.rangeStart = rangeStart;
	}

	public Date getRangeEnd() {
		return rangeEnd;
	}

	public void setRangeEnd(Date rangeEnd) {
		this.rangeEnd = rangeEnd;
	}

	public String getOther() {
		return other;
	}

	public void setOther(String other) {
		this.other = other;
	}	

	/**
	 * Format date for the Scheduled Date column into format that matches
	 * the rest of the columns
	 * @param date
	 * @return the formatted date string
	 */
	public static String formatDateForDisplay(Date date){
		DateFormat originalFormat = new SimpleDateFormat("yyyy-mm-dd");
		DateFormat targetFormat = new SimpleDateFormat("m/d/yyyy");
		Date temp= null;
		try {
			temp = originalFormat.parse(date.toString());
		} catch (ParseException e) {
			e.printStackTrace();
		}

		String formattedDate = targetFormat.format(temp);
		return formattedDate;
	}

	@Override
	public String toString() {
		return "BatchConfig [BatchJobId=" + batchJobId + ", rangeStart=" + rangeStart + ", rangeEnd=" + rangeEnd + "]";
	}
}
