package gov.va.cpss.job.updateicn;

import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.NonTransientResourceException;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;

/**
 * This is a dummy ItemReader for ICN Update. It only runs (reads) once.
 * 
 * @author Yiping Yao
 * @version 1.0 - 20160810
 *
 */
public class UpdateICNReader implements ItemReader<Object>
{
	private boolean isRead = false;

	@Override
	public Object read() throws Exception, UnexpectedInputException, ParseException, NonTransientResourceException
	{
		if (this.isRead)
		{
			// This will need to only read / run once, so if it is already read once, return null to stop the job.
			return null;
		}

		this.isRead = true;

		// Do nothing.
		// Just return an empty Object, so that the process can continue.
		return new Object();
	}
}
