package gov.va.cpss.job.sendcbs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import gov.va.cpss.model.cbs.CBSStmt;
import gov.va.cpss.model.fps.PSSite;

/**
 * Implementation of the interface for the runtime parameters used by the Send
 * CBS batch job during processing.
 * 
 * @author Brad Pickle
 */
public class SendCBSRuntimeStateImpl implements SendCBSRuntimeState {
	
	private List<PSSite> psSitesList = new ArrayList<PSSite>();
	
	private Map<String, List<CBSStmt>> cbsListsBySite = new HashMap<String, List<CBSStmt>>();

	private Map<String, List<CBSStmt>> sbsListsBySite = new HashMap<String, List<CBSStmt>>();

	@Override
	public List<PSSite> getPSSitesList() {
		return psSitesList;
	}

	@Override
	public Map<String, List<CBSStmt>> getCBSListsBySite() {
		return cbsListsBySite;
	}

	@Override
	public Map<String, List<CBSStmt>> getSBSListsBySite() {
		return sbsListsBySite;
	}

	@Override
	public void setCbsListsBySite(Map<String, List<CBSStmt>> cbsListsBySite) {
		this.cbsListsBySite = cbsListsBySite;
	}

	@Override
	public void setSbsListsBySite(Map<String, List<CBSStmt>> sbsListsBySite) {
		this.sbsListsBySite = sbsListsBySite;
	}

	@Override
	public void setPsSitesList(List<PSSite> psSitesList) {
		this.psSitesList = psSitesList;
	}

}
