package gov.va.cpss.job.sendcbs;

import java.util.List;
import java.util.Map;

import gov.va.cpss.model.cbs.CBSStmt;
import gov.va.cpss.model.fps.PSSite;

/**
 * Interface for the runtime parameters used by the Send CBS batch job during
 * processing.
 * 
 * @author Brad Pickle
 */
public interface SendCBSRuntimeState {
	/**
	 * @return	Modifiable List of PSSite records to output.
	 */
	List<PSSite> getPSSitesList();
	
	/**
	 * @return Modifiable Map of consolidated statements by site to output.
	 */
	Map<String, List<CBSStmt>> getCBSListsBySite();
	
	/**
	 * @return Modifiable Map of single statements by site to output.
	 */
	Map<String, List<CBSStmt>> getSBSListsBySite();

	/**
	 * @param cbsListsBySite
	 */
	void setCbsListsBySite(Map<String, List<CBSStmt>> cbsListsBySite);

	/**
	 * @param sbsListsBySite
	 */
	void setSbsListsBySite(Map<String, List<CBSStmt>> sbsListsBySite);
	
	/**
	 * @param psSitesList
	 */
	void setPsSitesList(List<PSSite> psSitesList);
}
