package gov.va.cpss.job.sendcbs;

/**
 * Constants used by Send CBS batch job to dynamically update the job execution
 * context during batch operations.
 * 
 * @author Brad Pickle
 */
public final class SendCBSProcessingConstants {

	/**
	 * The key to identify the database primary key value for the CBSMessage
	 * table entry associated with the job.
	 */
	public static final String CBS_MESSAGE_ID_KEY = "cbsMessageId";

	/**
	 * The key to identify the value used for the CBSStmtStatus NEW status id.
	 */
	public static final String NEW_STATUS_ID_KEY = "newStatusId";

	/**
	 * The key to identify the List of PSSite records to output.
	 */
	public static final String PS_SITES_LIST_KEY = "psSitesList";

	/**
	 * The key to identify the Map of consolidated statements by site.
	 */
	public static final String CBS_LISTS_BY_SITE_KEY = "cbsListsBySite";

	/**
	 * The key to identify the Map of single statements by site.
	 */
	public static final String SBS_LISTS_BY_SITE_KEY = "sbsListsBySite";

	/**
	 * The key to identify the file name for the consolidated statements staging
	 * file.
	 */
	public static final String CBS_OUTPUT_FILE_NAME_KEY = "cbsOutputFileName";

	/**
	 * The key to identify the file name for the single statements staging
	 * file.
	 */
	public static final String SBS_OUTPUT_FILE_NAME_KEY = "sbsOutputFileName";

	/**
	 * The key to identify the full path for the consolidated statements staging
	 * file.
	 */
	public static final String CBS_OUTPUT_RESOURCE_KEY = "cbsOutputResource";

	/**
	 * The key to identify the full path for the single statements staging
	 * file.
	 */
	public static final String SBS_OUTPUT_RESOURCE_KEY = "sbsOutputResource";

	/**
	 * The key to identify the total patients included in the delivered CBS
	 * file.
	 */
	public static final String CBS_TOTAL_PATIENTS_INCLUDED_KEY = "cbsTotalPatientsIncluded";
	
	/**
	 * The maximum number of records output per PS.
	 */
	public static final int CBS_MAX_RECORDS_PER_SITE = 9999;

}
