package gov.va.cpss.job.sendcbs;

import org.springframework.batch.item.file.transform.LineAggregator;
import org.springframework.classify.Classifier;

public class ClassifierLineAggregator<T> implements LineAggregator<T> {

	private Classifier<T, LineAggregator<? super T>> classifier;

	public void setClassifier(Classifier<T, LineAggregator<? super T>> classifier) {
		this.classifier = classifier;
	}

	@Override
	public String aggregate(T arg0) {
		
		LineAggregator<? super T> aggregator = classifier.classify(arg0);
		
		return aggregator.aggregate(arg0);
	}

}
