package gov.va.cpss.job.sendapps;

import static gov.va.cpss.model.ps.Constants.EMPTY_STRING;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;

//import org.apache.log4j.Logger;

import gov.va.cpss.cobol.Money;
import gov.va.cpss.model.apps.APSPayment;
import gov.va.cpss.model.apps.APSSitePatient;
import gov.va.cpss.model.apps.APSSiteStmt;
import gov.va.cpss.model.apps.APSStmt;
import gov.va.cpss.model.ps.RecordType;
import gov.va.cpss.model.sendapps.SendAPPSRecord;
import gov.va.cpss.model.sendapps.SendAppsPDRecord;
import gov.va.cpss.model.sendapps.SendAppsPHRecord;
import gov.va.cpss.model.sendcbs.PSDate;

/**
 * 
 * Note:
 * 
 * The majority of commented out code or changed / updated code are made
 * for fixing Defects 559107 and 568121.
 *       
 * Also, the majority of logic and processing should belong to
 * SendAPPSItemProcessor and SendAPPSService, and this class itself
 * may not be needed.
 * 
 *	Yiping Yao - 07/20/2017 - 08/05/2017
 *
 */
public class SendAPPSWriteAPPSRecordSource {
	//@SuppressWarnings("unused")
	//private Logger logger;

	private List<APSStmt> apsStmtList;
	private List<APSPayment> allApsPaymentList; // Yiping Yao 08/05/2017 - Fix for Defect 568121

	private static int totalPatientCount = 0;

	private int currentApsStmtIndex = 0;
	private int currentApsSiteStmtIndex = 0;
	private int currentApsPaymentIndex = 0;
	private int allApsPaymentIndex = 0; // Yiping Yao 07/20/2017 - Fix for Defect 559107

	private boolean phWritten = false;

	public SendAPPSWriteAPPSRecordSource() {
		//logger = Logger.getLogger(this.getClass().getCanonicalName());
	}

	public List<APSStmt> getApsStmtList() {
		return this.apsStmtList;
	}

	public void setApsStmtList(List<APSStmt> inApsStmtList) {
		this.apsStmtList = inApsStmtList;
	}

	public SendAPPSRecord<?> nextAPSRecord() {
		// Return null if all PS records processed
		if (!apsRecordsRemaining())
			return null;

		if (!this.phWritten)
			return nextPHRecord();

		return nextPDRecord();
	}

	public boolean apsRecordsRemaining() {
		return (this.currentApsStmtIndex < this.apsStmtList.size());
	}

	private SendAppsPHRecord nextPHRecord() {
		APSSiteStmt currentSiteStmt = getCurrentAPSSiteStmt();
		APSSitePatient appsSitePatient = currentSiteStmt.getPatient();

		// Yiping Yao 07/20/2017 - Fix for Defect 559107
		List<APSSiteStmt> currentAPPSSiteStmtList = getCurrentAPPSSiteStmtList();

		if (currentAPPSSiteStmtList != null && currentAPPSSiteStmtList.size() > 0)
		{
			// Yiping Yao 08/05/2017 - Fix for Defect 568121
			this.allApsPaymentList = new ArrayList<>();

			for (APSSiteStmt apsSiteStmt : currentAPPSSiteStmtList)
			{
				if (apsSiteStmt.getPayments() != null && apsSiteStmt.getPayments().size() > 0)
				{
					// Yiping Yao 08/05/2017 - Fix for Defect 568121
					this.allApsPaymentList.addAll(apsSiteStmt.getPayments());
				}
			}

			// Yiping Yao 08/05/2017 - Fix for Defect 568121
			// Sort by Payment Posted Date.
			this.allApsPaymentList.sort(Comparator.comparing(p -> p.getDatePosted(),
										Comparator.nullsFirst(Comparator.naturalOrder())));
		}

		SendAppsPHRecord phRecord = new SendAppsPHRecord();

		phRecord.setIcn(appsSitePatient.getIcn());
		phRecord.setSequenceNum(++totalPatientCount);

		phRecord.setAccountNumber(appsSitePatient.getAccountNumber());
		phRecord.setLastName(Optional.ofNullable(appsSitePatient.getLastName()).orElse(EMPTY_STRING));
		phRecord.setFirstName(Optional.ofNullable(appsSitePatient.getFirstName()).orElse(EMPTY_STRING));
		phRecord.setMiddleName(Optional.ofNullable(appsSitePatient.getMiddleName()).orElse(EMPTY_STRING));
		phRecord.setAddress1(Optional.ofNullable(appsSitePatient.getAddress1()).orElse(EMPTY_STRING));
		phRecord.setAddress2(Optional.ofNullable(appsSitePatient.getAddress2()).orElse(EMPTY_STRING));
		phRecord.setAddress3(Optional.ofNullable(appsSitePatient.getAddress3()).orElse(EMPTY_STRING));
		phRecord.setCity(Optional.ofNullable(appsSitePatient.getCity()).orElse(EMPTY_STRING));
		phRecord.setState(Optional.ofNullable(appsSitePatient.getState()).orElse(EMPTY_STRING));
		phRecord.setZipCode(Optional.ofNullable(appsSitePatient.getZipCode()).orElse(EMPTY_STRING));
		phRecord.setCountry(Optional.ofNullable(appsSitePatient.getCountry()).orElse(EMPTY_STRING));
		phRecord.setTotAmountReceived(getTotAmountReceived());
		//phRecord.setNumOfPd(currentSiteStmt.getPayments().size());
		phRecord.setNumOfPd(this.allApsPaymentList.size()); // Yiping Yao 07/20/2017 - Fix for Defect 559107
		phRecord.setDfnStr(Long.toString(appsSitePatient.getDfn()));
		phRecord.setType(RecordType.PH);

		// Mark the PH as written
		this.phWritten = true;

		return phRecord;
	}

	private SendAppsPDRecord nextPDRecord() {
		APSSiteStmt currentSiteStmt = getCurrentAPSSiteStmt();
		APSSitePatient appsSitePatient = currentSiteStmt.getPatient();
		APSPayment apsPayment = getCurrentAPSPayment();

		SendAppsPDRecord pdRecord = new SendAppsPDRecord();

		pdRecord.setIcn(appsSitePatient.getIcn());
		pdRecord.setSeqNum(this.allApsPaymentIndex+1); // Yiping Yao 07/20/2017 - Fix for Defect 559107
		pdRecord.setDatePosted(getPSDate(apsPayment.getDatePosted()));
		pdRecord.setStationDesc(currentSiteStmt.getFacilityNum());
		pdRecord.setTransAmount(new Money(apsPayment.getTransactionAmount().getDouble(), 11).getLong());
		pdRecord.setType(RecordType.PD);

		// Advance to the next APSPayment, APSSiteStmt, or APSStmt record
		advanceAPSPayment();

		return pdRecord;
	}

	private void advanceAPSPayment() {
		// Advance to next APSPayment
		this.currentApsPaymentIndex++;
		this.allApsPaymentIndex++; // Yiping Yao 07/20/2017 - Fix for Defect 559107

		// Yiping Yao 08/05/2017 - Fix for Defect 568121
		//if (getCurrentPaymentList().size() > this.currentApsPaymentIndex) {
		//	return;
		//}

		// No more APSPayment records. Advance to next APSSiteStmt
		//advanceAPSSiteStmt();
		if (getAllPaymentsList().size() > this.allApsPaymentIndex)
		{
			if (getCurrentAPSSiteStmt().getPayments().size() > this.currentApsPaymentIndex)
			{
				return;
			}

			advanceAPSSiteStmt();

			return;
		}

		// No more APSPayment records. Advance to next APSStmt
		advanceAPSStmt();
	}

	private void advanceAPSSiteStmt() {
		// Advance to next APSSiteStmt
		this.currentApsSiteStmtIndex++;

		this.currentApsPaymentIndex = 0;

		if (getCurrentAPPSSiteStmtList().size() > this.currentApsSiteStmtIndex) {
			return;
		}

		// Yiping Yao 08/05/2017 - Fix for Defect 568121
		// No more APSSiteStmt records. Advance to next APSStmt
		//advanceAPSStmt();
	}

	private void advanceAPSStmt() {
		// Advance to next APSStmt
		++this.currentApsStmtIndex;

		this.currentApsPaymentIndex = 0;
		this.currentApsSiteStmtIndex = 0;
		this.allApsPaymentIndex = 0; // Yiping Yao 07/20/2017 - Fix for Defect 559107
		this.phWritten = false;

		// Yiping Yao 08/05/2017 - Fix for Defect 568121
		this.allApsPaymentList.clear();
		this.allApsPaymentList = null;
	}

	private APSStmt getCurrentAPSStmt() {
		return ((this.apsStmtList == null) || (this.apsStmtList.size() <= this.currentApsStmtIndex)) ? null
				: this.apsStmtList.get(this.currentApsStmtIndex);
	}

	private List<APSSiteStmt> getCurrentAPPSSiteStmtList() {
		APSStmt appsStmt = getCurrentAPSStmt();
		return (appsStmt == null) ? null : appsStmt.getSiteStmts();
	}

	private APSSiteStmt getCurrentAPSSiteStmt() {
		List<APSSiteStmt> apsSiteStmtList = getCurrentAPPSSiteStmtList();
		return ((apsSiteStmtList == null) || (apsSiteStmtList.size() <= this.currentApsSiteStmtIndex)) ? null
				: apsSiteStmtList.get(this.currentApsSiteStmtIndex);
	}

	// Yiping Yao 08/05/2017 - Fix for Defect 568121
	private List<APSPayment> getAllPaymentsList()
	{
		return this.allApsPaymentList;
	}
	//private List<APSPayment> getCurrentPaymentList() {
	//	APSSiteStmt apsSiteStmt = getCurrentAPSSiteStmt();
	//	return (apsSiteStmt == null) ? null : apsSiteStmt.getPayments();
	//}

	private APSPayment getCurrentAPSPayment() {
		// Yiping Yao 08/05/2017 - Fix for Defect 568121
		//List<APSPayment> cbsSiteTransList = getCurrentPaymentList();
		//return ((cbsSiteTransList == null) || (cbsSiteTransList.size() <= this.currentApsPaymentIndex)) ? null
		//		: cbsSiteTransList.get(this.currentApsPaymentIndex);
		List<APSPayment> paymentsList = getAllPaymentsList();
		return ((paymentsList == null) || (paymentsList.size() <= this.allApsPaymentIndex)) ? null
				: paymentsList.get(this.allApsPaymentIndex);
	}

	@SuppressWarnings("static-method")
	private PSDate getPSDate(final Date date) {
		return (date == null) ? new PSDate(0L) : new PSDate(date.getTime());
	}

	private long getTotAmountReceived() {
		double sum = 0.0;
		for (APSSiteStmt siteStmt : getCurrentAPSStmt().getSiteStmts()) {
			sum += siteStmt.getTotalAmountReceived().getDouble();
		}
		return new Money(sum, 11).getLong();
	}
}
