package gov.va.cpss.job.sendapps;

import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_KEY;
import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_MESSAGE_KEY;
import static gov.va.cpss.job.CbssJobProcessingConstants.READ_FAILURE_STATUS;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import gov.va.cpss.job.CBSSPagingItemReader;
import gov.va.cpss.model.apps.APSStmt;
import gov.va.cpss.service.SendAPPSService;

@SuppressWarnings("nls")
public class SendAPPSItemReader extends CBSSPagingItemReader<APSStmt> {

	private SendAPPSService sendAppsService;

	public SendAPPSItemReader() {
	}

	public SendAPPSService getSendAppsService() {
		return this.sendAppsService;
	}

	public void setSendAppsService(SendAPPSService inSendAppsService) {
		this.sendAppsService = inSendAppsService;
	}

	@Override
	protected List<APSStmt> executePageRead(int page, int pageSize, Map<String, Object> inParameterValues) {
		this.logger.info("Before execute page read");
		
		final List<APSStmt> apsStmtL = this.sendAppsService.getApsStmtsWithPaging(page, pageSize);
		if(Objects.isNull(apsStmtL)) {
			setFailureStatusAndMessage(READ_FAILURE_STATUS, "Could not retrieve APSStmts for read.");
		}

		return apsStmtL;
	}

	/**
	 * Set the failure and message in the job execution context.
	 */
	private void setFailureStatusAndMessage(final String status, final String message) {
		// Set job failure.
		setFailureStatus(status);

		// Set job failure message.
		setFailureMessage(message);
	}

	/**
	 * Set the failure in the job execution context.
	 */
	private void setFailureStatus(final String status) {
		// Log job failure status.
		this.logger.error("Read failed with status: " + status);

		// Set job failure.
		this.getJobExecution().getExecutionContext().putString(JOB_FAILURE_KEY, status);
	}

	/**
	 * Set the failure message in the job execution context.
	 */
	private void setFailureMessage(final String message) {
		// Log job failure message.
		this.logger.error("Read failure message: " + message);

		// Set job failure message.
		this.getJobExecution().getExecutionContext().putString(JOB_FAILURE_MESSAGE_KEY, message);
	}
}
