package gov.va.cpss.job.printack;

import static gov.va.cpss.job.CbssJobProcessingConstants.DATA_ERROR_STATUS;

import java.util.List;

import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.scope.context.ChunkContext;

import gov.va.cpss.job.CbssJobBaseTransactionTasklet;
import gov.va.cpss.job.UpdatePrintAckJob;
import gov.va.cpss.service.Result;
import gov.va.cpss.service.UpdatePrintAckService;

public class UpdatePrintAckUndoAcksCompletionTasklet extends CbssJobBaseTransactionTasklet {

	private UpdatePrintAckService updatePrintAckService;

	public UpdatePrintAckService getUpdatePrintAckService() {
		return updatePrintAckService;
	}

	public void setUpdatePrintAckService(UpdatePrintAckService updatePrintAckService) {
		this.updatePrintAckService = updatePrintAckService;
	}

	@Override
	protected boolean executeLogic(ChunkContext chunkContext) {
		boolean successful = true;

		taskletLogger.info("Undo Print Acknowledgements Tasklet Running!");
		
		final JobExecution jobExecution = chunkContext.getStepContext().getStepExecution().getJobExecution();
		
		final List<Long> printAckRecIdList = UpdatePrintAckJob.getCurrentFilePrintAckRecIdList(jobExecution);

		final Result<Object[]> result = updatePrintAckService.undoPrintAcknowledgements(printAckRecIdList);
		
		if (! result.isSuccessful()) {
			// If the undo fails, then exit with error.
			setFailureStatus(jobExecution, DATA_ERROR_STATUS, "Rollback Triggered: " + result.getMessage());
			
			successful = false;
		}

		return successful;
	}

}
