package gov.va.cpss.job.printack;

import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_KEY;

import org.apache.log4j.Logger;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;

public class UpdatePrintAckStepExecutionListener implements StepExecutionListener {

	private final Logger listenerLogger;

	public UpdatePrintAckStepExecutionListener() {
		listenerLogger = Logger.getLogger(this.getClass().getCanonicalName());
	}

	@Override
	public void beforeStep(StepExecution stepExecution) {
		// Do not need to do anything before step.
	}

	@Override
	public ExitStatus afterStep(StepExecution stepExecution) {

		listenerLogger.info("After Step");

		ExitStatus stepStatus = stepExecution.getExitStatus();

		// Capture the ExitStatus for the Step and handle appropriately.
		if (!stepStatus.equals(ExitStatus.COMPLETED)
				|| stepExecution.getJobExecution().getExecutionContext().containsKey(JOB_FAILURE_KEY)) {

			if (stepExecution.getJobExecution().getExecutionContext().containsKey(JOB_FAILURE_KEY)) {
				listenerLogger.info("Handling Failure: "
						+ stepExecution.getJobExecution().getExecutionContext().getString(JOB_FAILURE_KEY));
			} else {
				listenerLogger.info("Handling Step Status: " + stepStatus);
				stepExecution.getJobExecution().getExecutionContext().putString(JOB_FAILURE_KEY, stepStatus.toString());
			}

			return ExitStatus.FAILED;
		}

		return ExitStatus.COMPLETED;
	}

}
