package gov.va.cpss.job.printack;

/**
 * Constants used by Update Print Ack batch job.
 * 
 * @author Brad Pickle
 */
public final class UpaProcessingConstants {

	/**
	 * The key to identify the database primary key value for the BatchRun table
	 * entry associated with the job.
	 */
	public static final String BATCH_RUN_ID_KEY = "batchRunId";

	/**
	 * The key to identify the input resource.
	 */
	public static final String INPUT_RESOURCE_KEY = "inputResource";

	/**
	 * The key to identify the data directory holding the input resource.
	 */
	public static final String INPUT_DIRECTORY_KEY = "inputDirectory";

	/**
	 * The key to identify the date received of the input resource.
	 */
	public static final String DATE_RECEIVED_KEY = "dateReceived";

	/**
	 * The key to identify the total CBS received in the file being processed.
	 */
	public static final String TOTAL_CBS_RECEIVED_KEY = "totalCbsReceived";

	/**
	 * The key to identify the total CBS updated while processing the print
	 * acknowledgments.
	 */
	public static final String TOTAL_CBS_UPDATED_KEY = "totalCbsUpdated";

	/**
	 * The key to identify the List of printAckRec Ids that have been created.
	 */
	public static final String PRINT_ACK_REC_ID_LIST_KEY = "printAckRecIdList";
	
	/**
	 * The key to identify the List of missing patient accounts.
	 */
	public static final String MISSING_PATIENT_ACCT_LIST_KEY = "missingPatientAcctList";
}
