package gov.va.cpss.job.printack;

import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.springframework.batch.item.file.mapping.DefaultLineMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

import gov.va.cpss.model.printack.ADFileRecord;
import gov.va.cpss.model.printack.DetailListField;

/**
 * Editor for parsing the Detail portion (AD) of PA records. Expects a list of
 * AD records delimited by the specified recordDelimiter, default |. Returns a
 * List of ADFileRecord objects parsed from the AD records.
 * 
 * @author Brad Pickle
 */
public class DetailListFieldEditor extends PropertyEditorSupport implements InitializingBean {

	public static String DEFAULT_RECORD_DELIMITER = "|";

	private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());;

	private String recordDelimiter = DEFAULT_RECORD_DELIMITER;

	private DefaultLineMapper<ADFileRecord> adFileRecordLineMapper;

	public String getRecordDelimiter() {
		return recordDelimiter;
	}

	public void setRecordDelimiter(String recordDelimiter) {
		this.recordDelimiter = recordDelimiter;
	}

	public DefaultLineMapper<ADFileRecord> getAdFileRecordLineMapper() {
		return adFileRecordLineMapper;
	}

	public void setAdFileRecordLineMapper(DefaultLineMapper<ADFileRecord> adFileRecordLineMapper) {
		this.adFileRecordLineMapper = adFileRecordLineMapper;
	}

	@Override
	public void setAsText(String text) {
		logger.debug("Parsing:" + text);
		try {
			final List<ADFileRecord> printAckDetailL = new ArrayList<ADFileRecord>();

			if (text != null) {
				String[] adRecords = text.split(recordDelimiter);
				logger.debug("Number of fields found:" + adRecords.length);

				int lineNumber = 1;
				for (String adRecord : adRecords) {
					printAckDetailL.add(adFileRecordLineMapper.mapLine(adRecord, lineNumber++));
				}
			}

			setValue(new DetailListField() {
				@Override
				public List<ADFileRecord> getPrintAckDetailL() {
					return printAckDetailL;
				}
			});
		} catch (Exception e) {
			logger.error("Caught exception: " + e.getMessage());
			throw new RuntimeException(e);
		}
	}

	@Override
	public void afterPropertiesSet() throws Exception {
		Assert.notNull(adFileRecordLineMapper, "The ADFileRecordLineMapper must be set");
	}
}
