package gov.va.cpss.job.loadbill;

import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_KEY;
import static gov.va.cpss.job.CbssJobProcessingConstants.JOB_FAILURE_MESSAGE_KEY;
import static gov.va.cpss.job.CbssJobProcessingConstants.READ_FAILURE_STATUS;
import static gov.va.cpss.job.loadbill.LoadBillProcessingConstants.PU_HEADER_COMPLETE_KEY;

import org.apache.log4j.Logger;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;

/**
 * Custom JobExecutionListener used to process custom exit status to handle
 * errors during Load Bill batch job execution.
 * 
 * @author DNS  
 */
public class LoadBillJobExecutionListener implements JobExecutionListener {

	private final Logger listenerLogger = Logger.getLogger(LoadBillJobExecutionListener.class.getCanonicalName());

	@Override
	public void beforeJob(JobExecution jobExecution) {
		listenerLogger.info("Beginning Job Execution");
	}
	
	@Override
	public void afterJob(JobExecution jobExecution) {

		listenerLogger.info("After Job");

		// System failure takes precedence over data error.
		if (jobExecution.getExecutionContext().containsKey(JOB_FAILURE_KEY)) {

			final String exitStatus = jobExecution.getExecutionContext().getString(JOB_FAILURE_KEY);

			if (jobExecution.getExecutionContext().containsKey(JOB_FAILURE_MESSAGE_KEY)) {

				final String exitMessage = jobExecution.getExecutionContext().getString(JOB_FAILURE_MESSAGE_KEY);

				listenerLogger.error("JobFailure detected, setting exit status (" + exitStatus + "): " + exitMessage);

				jobExecution.setExitStatus(new ExitStatus(exitStatus, exitMessage));
			} else {

				listenerLogger.error("JobFailure detected, setting exit status (" + exitStatus + ")");

				jobExecution.setExitStatus(new ExitStatus(exitStatus));
			}

		} else if (jobExecution.getExecutionContext().containsKey(PU_HEADER_COMPLETE_KEY)) {

			final String completeHeader = jobExecution.getExecutionContext().getString(PU_HEADER_COMPLETE_KEY);

			if (!Boolean.valueOf(completeHeader)) {
				
				final String exitStatus = READ_FAILURE_STATUS;
				
				final String exitMessage = "Incomplete header found";
				
				listenerLogger.error("JobFailure detected, setting exit status (" + exitStatus + "): " + exitMessage);

				jobExecution.setExitStatus(new ExitStatus(exitStatus, exitMessage));
			} else {
				jobExecution.setExitStatus(ExitStatus.COMPLETED);
			}
		}

		listenerLogger.info("Ending Job Execution");
	}

}
