package gov.va.cpss.job.loadbill;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.BlockingQueue;

import gov.va.cpss.job.CbssStreamToQueueThread;

public class CbssStreamToQueueThreadLoadBillImpl extends CbssStreamToQueueThread {

	/**
	 * Constructor for thread to process the provided input stream in to an
	 * output queue for each record as indicated by a line feed. The expected
	 * bytes is provided for verification check the data was successfully
	 * processed.
	 * 
	 * @param expectedByteCount
	 *            The expected amount of bytes to read.
	 * @param in
	 *            The input stream.
	 * @param outputQueue
	 *            The output queue.
	 * @throws UnsupportedEncodingException
	 */
	public CbssStreamToQueueThreadLoadBillImpl(long expectedByteCount, InputStream in,
			BlockingQueue<String> outputQueue) throws UnsupportedEncodingException {
		super(expectedByteCount, in, outputQueue);
	}
	
	@Override
	public boolean populateQueue() {
		boolean successful = false;

		try {
			String line = bufferedReader.readLine();
			
			// Loop until thread is interrupted or no more lines available.
			while (!isInterrupted() && (line != null)) {
				if (!line.isEmpty()) {
					//Split the line based on the pipe delimiter or tilde
					String[] recordArray = line.split("[|~]");
					for(int i = 0; i < recordArray.length; i++) {
//						logger.info("SAVING INTO Q: |" + recordArray[i] + "|");
						outputQueue.put(recordArray[i]);
					}
				}
				line = bufferedReader.readLine();
			}
			
			successful = true;
		} catch (IOException | InterruptedException e) {
			logger.error("Exception occurred during processing file stream into queue: " + e.getMessage());
		} finally {
			try {
				bufferedReader.close();
				successful = true;
			} catch (IOException e) {
				logger.error("Exception occurred when attempting to close reader: " + e.getMessage());
			}
		}

		return successful;
	}
}
