package gov.va.cpss.job.fps;

import org.apache.log4j.Logger;
import org.springframework.classify.Classifier;

import gov.va.cpss.model.fps.PSRecord;

/**
 * Classifier used by the Process FPS Data batch job PatternMatchingCompositeLineMapper to
 * determine which tokenizer to use based on the first entry key of the data row. 
 *  
 * @author DNS  
 */
public class FpsClassifier implements Classifier<Object, Object> {

    private final Logger classifierLogger;

    public FpsClassifier() {
        classifierLogger = Logger.getLogger(this.getClass().getCanonicalName());
    }

    @Override
    public Object classify(Object arg0) {

        classifierLogger.debug("Classifying record for writing");

        if (!(arg0 instanceof PSRecord)) {
            classifierLogger.error("Unable to classify object for writing");
            return PSRecord.DataType.UNDEFINED.getName();
        }

        return ((PSRecord) arg0).getType().getName();
    }

}
